/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.common;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Maps;
import java.beans.Transient;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public abstract class AbstractConfiguration<T, V>
extends LabeledStorable
implements Map<T, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfiguration.class);
    private Map<T, V> configuration = Maps.newHashMapWithExpectedSize((int)20);
    private String typeName;

    public AbstractConfiguration() {
    }

    public AbstractConfiguration(String typeName) {
        this.typeName = typeName;
    }

    @Override
    @Transient
    public int size() {
        return this.configuration.size();
    }

    @Override
    @Transient
    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    @Override
    @Transient
    public boolean containsKey(Object key) {
        return this.configuration.containsKey(key);
    }

    @Override
    @Transient
    public boolean containsValue(Object value) {
        return this.configuration.containsValue(value);
    }

    @Override
    @Transient
    public V get(Object key) {
        return this.configuration.get(key);
    }

    @Override
    @Transient
    public V put(T key, V value) {
        return this.configuration.put(key, value);
    }

    @Override
    @Transient
    public V remove(Object key) {
        return this.configuration.remove(key);
    }

    @Override
    @Transient
    public void putAll(Map<? extends T, ? extends V> m) {
        this.configuration.putAll(m);
    }

    @Override
    @Transient
    public void clear() {
        this.configuration.clear();
    }

    @Override
    @Transient
    public Set<T> keySet() {
        return this.configuration.keySet();
    }

    @Override
    @Transient
    public Collection<V> values() {
        return this.configuration.values();
    }

    @Override
    @Transient
    public Set<Map.Entry<T, V>> entrySet() {
        return this.configuration.entrySet();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Map<T, V> getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Map<T, V> configuration) {
        this.configuration = configuration;
    }

    @Transient
    public void fillConfiguration(Map<T, V> configuration) {
        StorableUtils.fillMap(this.getConfiguration(), configuration);
    }
}

