/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.context;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Entity;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonStorable;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.JsonRef;

@Entity
@JsonFilter(value="reportWorkerFilter_InstanceContext")
public class InstanceContext
extends JsonStorable {
    private static final long serialVersionUID = 20240812L;
    private BigInteger projectId;
    private UUID projectUuid;
    public static final String SESSION_ID = "sessionId";
    public static final String TRANSPORT = "_transport";
    public static final String CONNECTION_PROPERTIES = "_connection_properties";
    public static final String BROKER_MESSAGE_SELECTOR_VALUE = "brokerMessageSelectorValue";
    private AbstractInstance instance;

    public InstanceContext() {
        this.setStartTime(new Date());
    }

    public InstanceContext(AbstractInstance instance) {
        this.instance = instance;
    }

    public static InstanceContext from(TcContext tc, SpContext sp) {
        InstanceContext context = new InstanceContext();
        context.put("tc", tc);
        context.put("sp", sp);
        return context;
    }

    public TcContext tc() {
        return this.get("tc", TcContext.class);
    }

    public SpContext sp() {
        return this.get("sp", SpContext.class);
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    public UUID getProjectUuid() {
        return this.projectUuid;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    @JsonRef
    public TcContext getTC() {
        return this.get("tc", TcContext.class);
    }

    public SpContext getSP() {
        return this.get("sp", SpContext.class);
    }

    public void setTC(TcContext tc) {
        this.put("tc", tc);
    }

    public void setSP(SpContext sp) {
        this.put("sp", sp);
    }

    public void nilsp() {
        this.remove("sp");
    }

    public void setSessionId(Object sessionId) {
        this.put(SESSION_ID, sessionId);
    }

    public Object getSessionId() {
        return this.get(SESSION_ID);
    }

    public void setMessageBrokerSelectorValue(Object brokerSelectorValue) {
        this.put(BROKER_MESSAGE_SELECTOR_VALUE, brokerSelectorValue);
    }

    public Object getMessageBrokerSelectorValue() {
        return this.get(BROKER_MESSAGE_SELECTOR_VALUE);
    }

    @JsonRef
    public AbstractInstance getInstance() {
        return this.instance;
    }

    public void setInstance(AbstractInstance instance) {
        this.instance = instance;
    }

    public TransportConfiguration getTransport() {
        return this.get(TRANSPORT, TransportConfiguration.class);
    }

    public void setTransport(TransportConfiguration transport) {
        this.put(TRANSPORT, transport);
    }

    public void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.put(CONNECTION_PROPERTIES, connectionProperties);
    }

    public ConnectionProperties getConnectionProperties() {
        return this.get(CONNECTION_PROPERTIES, ConnectionProperties.class);
    }

    @Override
    public void setJsonString(String jsonString) throws ParseException {
        JSONParser parser = new JSONParser();
        if (Strings.isNullOrEmpty((String)jsonString)) {
            return;
        }
        Object parse = parser.parse(jsonString);
        if (parse instanceof Map) {
            ((Map)parse).remove("tc");
            ((Map)parse).remove("sp");
            this.putAll((Map)parse);
        } else {
            this.put("parsed", parse);
        }
    }

    @Override
    public String getJsonString() {
        JsonContext copy = new JsonContext();
        copy.putAll((Map)this);
        copy.remove("tc");
        copy.remove("sp");
        return copy.getJsonString();
    }
}

