/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.context;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.automation.itf.core.model.extension.Extendable;
import org.qubership.automation.itf.core.model.extension.ExtendableImpl;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.model.jpa.context.IJsonContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonStorable;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public class JsonContext
extends JSONObject
implements IJsonContext,
Extendable {
    private static final long serialVersionUID = 20240812L;
    private static final Splitter SPLITTER = Splitter.on((char)'.');
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(\\w+)\\s*\\[\\s*(\\d+)\\s*\\]");
    private static final Pattern MAP_PATTERN = Pattern.compile("(\\w+)\\s*\\[\\s*(\"|')(\\w+)(\\2)\\s*\\]");
    private Object version;
    private List<String> labels = Lists.newArrayListWithExpectedSize((int)10);
    private ExtendableImpl extendable = new ExtendableImpl();
    private transient WeakHashMap<Object, Pair<Object, Object>> history = new WeakHashMap();
    private boolean collectHistory = false;

    public static <T extends JsonStorable> T fromJson(String jsonString, Class<T> clazz) throws ParseException, IllegalAccessException, InstantiationException {
        JsonStorable instance = (JsonStorable)clazz.newInstance();
        instance.setJsonString(jsonString);
        return (T)instance;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.iterateForGet((String)key, false, true);
        }
        return super.get(key);
    }

    @Override
    public <T> T get(String key, Class<T> castTo) {
        try {
            return this.getCast(key, castTo);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void putAll(Map m) {
        if (this.collectHistory) {
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                if (!this.containsKey(entry.getKey())) continue;
                this.history.put(entry.getKey(), (Pair<Object, Object>)ImmutablePair.of((Object)super.get(entry.getKey()), entry.getValue()));
            }
        }
        super.putAll(m);
    }

    public Object put(Object key, Object value) {
        Object obj;
        Object object = obj = key instanceof String ? this.iterateForPut((String)key, value) : super.put(key, value);
        if (this.collectHistory) {
            this.history.put(key, (Pair<Object, Object>)ImmutablePair.of((Object)obj, (Object)value));
        }
        return obj;
    }

    private void put(Map to, Object fromKey, Object fromValue, boolean addNewOnly) {
        if (addNewOnly) {
            to.putIfAbsent(fromKey, fromValue);
            return;
        }
        to.put(fromKey, fromValue);
    }

    public Map<Object, Pair<Object, Object>> getHistory() {
        return Maps.newHashMap(this.history);
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String ? this.iterateForGet((String)key, false, false) != null : super.containsKey(key);
    }

    @Override
    public Object create(Object key, boolean list) {
        Object o = list ? new JSONArray() : new JsonContext();
        return this.put(key, o);
    }

    @Override
    public Object create(Object key) {
        return this.create(key, false);
    }

    private Object iterateForGet(String stringKey, boolean checkLast, boolean doThrow) {
        Object tmpObject = this;
        Iterator iterator = SPLITTER.split((CharSequence)stringKey).iterator();
        Matcher arrayMatcher = ARRAY_PATTERN.matcher("");
        Matcher mapMatcher = MAP_PATTERN.matcher("");
        do {
            String keyPart = (String)iterator.next();
            if (checkLast && !iterator.hasNext()) break;
            if (tmpObject == null) {
                if (doThrow) {
                    throw new IllegalStateException(String.format("Full key is '%s'. Cannot take property \"%s\" (may be there are dots in the full key?).", stringKey, keyPart));
                }
                return null;
            }
            if (tmpObject instanceof Map) {
                Object o;
                String varName;
                if (arrayMatcher.reset(keyPart).matches()) {
                    varName = arrayMatcher.group(1);
                    int index = Integer.parseInt(arrayMatcher.group(2));
                    o = ((Map)tmpObject).get(varName);
                    if (o instanceof List) {
                        if (((List)o).size() > index) {
                            tmpObject = ((List)o).get(index);
                            continue;
                        }
                        return null;
                    }
                    if (doThrow) {
                        throw new IllegalStateException(String.format("Cannot take index \"%s\" from object [%s], class is [%s]. Object is not list. Full key is '%s'", index, tmpObject, tmpObject.getClass().getSimpleName(), stringKey));
                    }
                    return null;
                }
                if (mapMatcher.reset(keyPart).matches()) {
                    varName = mapMatcher.group(1);
                    String subVarName = mapMatcher.group(3);
                    o = ((Map)tmpObject).get(varName);
                    if (o instanceof Map) {
                        tmpObject = ((Map)o).get(subVarName);
                        continue;
                    }
                    if (doThrow) {
                        throw new IllegalStateException(String.format("Cannot take property \"%s\" from object [%s], class is [%s]. Object is not map. Full key is '%s'", subVarName, tmpObject, tmpObject.getClass().getSimpleName(), stringKey));
                    }
                    return null;
                }
                tmpObject = tmpObject == this ? super.get((Object)keyPart) : ((Map)tmpObject).get(keyPart);
                continue;
            }
            if (doThrow) {
                throw new IllegalStateException(String.format("Cannot take property \"%s\" from object [%s], class is [%s]. Object is not map. Full key is '%s'", keyPart, tmpObject, tmpObject.getClass().getSimpleName(), stringKey));
            }
            return null;
        } while (iterator.hasNext());
        return tmpObject;
    }

    private Object iterateForPut(String key, Object value) {
        String simpleName;
        String lastKey;
        Object tmpObject = this.iterateForGet(key, true, true);
        Iterator iterator = SPLITTER.split((CharSequence)key).iterator();
        do {
            lastKey = (String)iterator.next();
        } while (iterator.hasNext());
        Matcher arrayMatcher = ARRAY_PATTERN.matcher(lastKey);
        Matcher mapMatcher = MAP_PATTERN.matcher(lastKey);
        String string = simpleName = tmpObject == null ? "null" : tmpObject.getClass().getSimpleName();
        if (arrayMatcher.matches()) {
            String varName = arrayMatcher.group(1);
            int index = Integer.parseInt(arrayMatcher.group(2));
            if (tmpObject instanceof Map) {
                Object o = ((Map)tmpObject).get(varName);
                if (o == null) {
                    o = new JSONArray();
                    ((Map)tmpObject).put(varName, o);
                }
                if (o instanceof List) {
                    List list = (List)o;
                    if (index == list.size()) {
                        list.add(value);
                        return null;
                    }
                    if (list.size() < index) {
                        ((JSONArray)list).ensureCapacity(index + 1);
                        for (int number = list.size(); number < index + 1; ++number) {
                            list.add(null);
                        }
                    }
                    Object toReturn = list.get(index);
                    list.set(index, value);
                    return toReturn;
                }
                throw new IllegalStateException(String.format("Cannot set value by index \"%s\" to object [%s], class is [%s]. Object is not list. Full key is '%s'", index, o, o.getClass().getSimpleName(), key));
            }
            throw new IllegalStateException(String.format("Cannot take property \"%s\" from object [%s], class is [%s]. Object is not map. Full key is '%s'", varName, tmpObject, simpleName, key));
        }
        if (mapMatcher.matches()) {
            String varName = mapMatcher.group(1);
            String subVarName = mapMatcher.group(3);
            if (tmpObject instanceof Map) {
                Object o = ((Map)tmpObject).get(varName);
                if (o == null) {
                    o = new JsonContext();
                    ((Map)tmpObject).put(varName, o);
                }
                if (o instanceof Map) {
                    return ((Map)o).put(subVarName, value);
                }
                throw new IllegalStateException(String.format("Cannot set property \"%s\" to object [%s], class is [%s]. Object is not map. Full key is '%s'", subVarName, o, o.getClass().getSimpleName(), key));
            }
            throw new IllegalStateException(String.format("Cannot take property \"%s\" from object [%s], class is [%s]. Object is not map. Full key is '%s'", varName, tmpObject, simpleName, key));
        }
        if (tmpObject instanceof Map) {
            return tmpObject == this ? super.put((Object)lastKey, value) : ((Map)tmpObject).put(lastKey, value);
        }
        throw new IllegalStateException(String.format("Cannot set property \"%s\" to object [%s], class is [%s]. Object is not map. Full key is '%s'", lastKey, tmpObject, simpleName, key));
    }

    public <T> T getCast(String key, Class<T> castTo) throws ClassCastException {
        Object o = this.get(key);
        return o != null ? (T)castTo.cast(o) : null;
    }

    @Override
    public void merge(Map from) {
        if (from == null || from.isEmpty()) {
            return;
        }
        this.mergeMap(this, from, false);
    }

    private void merge(Map to, Object fromKey, Object fromValue, boolean addNewOnly) {
        Object toValue = to.get(fromKey);
        if (toValue instanceof Map && fromValue instanceof Map) {
            this.mergeMap((Map)toValue, (Map)fromValue, addNewOnly);
        } else if (toValue instanceof List && fromValue instanceof List) {
            this.mergeList((List)toValue, (List)fromValue, addNewOnly);
        } else {
            this.put(to, fromKey, fromValue, addNewOnly);
        }
    }

    public void putIfAbsent(Map from) {
        this.mergeMap(this, from, true);
    }

    public void mergeMap(Map to, Map from, boolean addNewOnly) {
        Iterator iterator = from.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            Object fromValue = entry.getValue();
            Object fromKey = entry.getKey();
            if (to.containsKey(fromKey)) {
                this.merge(to, fromKey, fromValue, addNewOnly);
                continue;
            }
            this.add(to, fromKey, fromValue);
        }
    }

    private void add(Map to, Object fromKey, Object fromValue) {
        String[] split = fromKey.toString().split("\\.");
        String group = split[0];
        if (!to.containsKey(group)) {
            to.put(group, new JSONObject());
        }
        if (fromValue instanceof Map) {
            JsonContext toChild = new JsonContext();
            Iterator iterator = ((Map)fromValue).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry val;
                Map.Entry valEntry = val = iterator.next();
                Object valValue = valEntry.getValue();
                Object valKey = valEntry.getKey();
                if (valKey instanceof String && ((String)valKey).contains(".")) {
                    this.checkOrCreateParents(toChild, (String)valKey, valValue);
                    continue;
                }
                toChild.put(valKey, valValue);
            }
            to.put(fromKey, toChild);
        } else {
            to.put(fromKey, fromValue);
        }
    }

    private void checkOrCreateParents(JSONObject to, String key, Object value) {
        String[] names = key.split("\\.");
        JSONObject curObj = to;
        for (int i = 0; i < names.length; ++i) {
            if (!curObj.containsKey((Object)names[i])) {
                if (i == names.length - 1) {
                    curObj.put((Object)names[i], value);
                    break;
                }
                curObj.put((Object)names[i], (Object)new JSONObject());
            }
            curObj = (JSONObject)curObj.get((Object)names[i]);
        }
    }

    private void mergeList(List to, List from, boolean addNewOnly) {
        int toSize = to.size();
        int fromSize = from.size();
        for (int i = 0; i < toSize && i < fromSize; ++i) {
            this.mergeListElement(to, from, addNewOnly, i);
        }
        if (addNewOnly) {
            this.addNewListElementsIfNotContains(to, from, fromSize);
            return;
        }
        this.addListElementsAfterReplaceExisting(to, from, fromSize, toSize);
    }

    private void mergeListElement(List to, List from, boolean addNewOnly, int elementIndex) {
        Object toValue = to.get(elementIndex);
        Object fromValue = from.get(elementIndex);
        if (toValue instanceof Map && fromValue instanceof Map) {
            this.mergeMap((Map)toValue, (Map)fromValue, addNewOnly);
        } else if (toValue instanceof List && fromValue instanceof List) {
            this.mergeList((List)toValue, (List)fromValue, addNewOnly);
        } else if (!addNewOnly) {
            to.set(elementIndex, fromValue);
        }
    }

    private void addListElementsAfterReplaceExisting(List to, List from, int fromSize, int toSize) {
        if (fromSize > toSize) {
            for (int i = toSize; i < fromSize; ++i) {
                to.add(i, from.get(i));
            }
        }
    }

    private void addNewListElementsIfNotContains(List to, List from, int fromSize) {
        for (int i = 0; i < fromSize; ++i) {
            Object element = from.get(i);
            if (to.contains(element)) continue;
            to.add(element);
        }
    }

    public boolean isCollectHistory() {
        return this.collectHistory;
    }

    public JsonContext setCollectHistory(boolean collectHistory) {
        this.collectHistory = collectHistory;
        return this;
    }

    @Override
    public boolean extend(Extension extension) {
        return this.extendable.extend(extension);
    }

    @Override
    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        return this.extendable.getExtension(extensionClass);
    }

    @Override
    public String getExtensionsJson() {
        return this.extendable.getExtensionsJson();
    }

    @Override
    public void setExtensionsJson(String extensionsJson) {
        this.extendable.setExtensionsJson(extensionsJson);
    }

    public String getJsonString() {
        return this.toJSONString();
    }

    protected void setJsonString(String jsonString) throws ParseException {
        JSONParser parser = new JSONParser();
        if (Strings.isNullOrEmpty((String)jsonString)) {
            return;
        }
        Object parse = parser.parse(jsonString);
        if (parse instanceof Map) {
            this.putAll((Map)parse);
        } else {
            this.put("parsed", parse);
        }
    }
}

