/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.instance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.util.annotation.JsonRef;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.iterator.AbstractStepIterator;

@Entity
public abstract class AbstractContainerInstance
extends AbstractInstance {
    private TcContext parentContext;
    private List<StepInstance> stepInstances = Lists.newArrayListWithExpectedSize((int)3);

    @JsonIgnore
    public List<StepInstance> getStepInstances() {
        return this.stepInstances;
    }

    protected void setStepInstances(List<StepInstance> stepInstances) {
        this.stepInstances = stepInstances;
    }

    public void fillStepInstances(List<StepInstance> stepInstances) {
        StorableUtils.fillCollection(this.getStepInstances(), stepInstances);
    }

    @JsonIgnore
    public abstract AbstractStepIterator iterator();

    @JsonRef
    public abstract StepContainer getStepContainer();

    public abstract void setStepContainer(StepContainer var1);

    @Override
    public String toString() {
        if (this.getStepContainer() != null) {
            return String.format("Instance: [%s]", this.getStepContainer().getName());
        }
        return "";
    }

    @JsonRef
    public TcContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(TcContext parentContext) {
        this.parentContext = parentContext;
    }
}

