/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.message.parser;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigInteger;
import org.jdom2.Element;
import org.json.simple.JSONObject;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.helper.ContentHelper;
import org.qubership.automation.itf.core.util.parser.ParsingRuleType;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractParsingRule<T extends ParsingRuleProvider>
extends AbstractStorable
implements ParsingRule<T> {
    private Boolean multiple = false;
    private String paramName;
    private String expression;
    private String parsedExpression = "";
    private Boolean autosave = false;
    private ParsingRuleType parsingType;
    private BigInteger projectId;
    private T parent;

    public AbstractParsingRule(T parent) {
        this.setParent(parent);
        this.setProjectId(parent.getProjectId());
        parent.returnParsingRules().add(this);
    }

    @Override
    public MessageParameter apply(Message message, InstanceContext context, boolean projectExpressionVarValue) {
        this.parsedExpression = this.computeParsedExpression(context, projectExpressionVarValue);
        return this.parsingType.parse(message, this);
    }

    @Override
    public boolean applicable(Message message) {
        switch (this.parsingType) {
            case XPATH: {
                return ContentHelper.getInstance().tryForContentType(Element.class, message);
            }
            case REGEX: 
            case REGEX_HEADER: 
            case REGEX_URI: {
                return true;
            }
            case JSON_PATH: {
                return ContentHelper.getInstance().tryForContentType(JSONObject.class, message);
            }
        }
        throw new IllegalArgumentException("Undefined type of parsing rule: " + this.parsingType.name());
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    @Override
    public abstract String getParsingRulePath();

    @Override
    public void fillProperties(String paramName, String type, String expression, String multiple, String autosave) {
        this.setParamName(paramName);
        this.setParsingType(ParsingRuleType.from(type));
        this.setExpression(expression);
        this.setMultiple(Boolean.valueOf(multiple));
        this.setAutosave(Boolean.valueOf(autosave));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParsingRule parsingRule = (ParsingRule)obj;
        return (this.getID() != null || parsingRule.getID() != null) && this.getID() == parsingRule.getID() && this.paramName.equals(parsingRule.getParamName());
    }

    @Override
    public int hashCode() {
        return (this.getID() + this.paramName).hashCode();
    }

    private String computeParsedExpression(InstanceContext context, boolean projectExpressionVarValue) {
        if (projectExpressionVarValue) {
            try {
                return TemplateEngineFactory.process(null, this.getExpression(), context);
            }
            catch (Exception ex) {
                LOGGER.warn("Parameter {}: Velocity exception while rule expression parsing - {}", (Object)this.paramName, (Object)ex.getMessage());
                return this.expression;
            }
        }
        return this.expression;
    }

    @Override
    public Boolean getMultiple() {
        return this.multiple;
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getParsedExpression() {
        return this.parsedExpression;
    }

    @Override
    public Boolean getAutosave() {
        return this.autosave;
    }

    @Override
    public ParsingRuleType getParsingType() {
        return this.parsingType;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    @Override
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    @Override
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setParsedExpression(String parsedExpression) {
        this.parsedExpression = parsedExpression;
    }

    @Override
    public void setAutosave(Boolean autosave) {
        this.autosave = autosave;
    }

    @Override
    public void setParsingType(ParsingRuleType parsingType) {
        this.parsingType = parsingType;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    @Override
    public void setParent(T parent) {
        this.parent = parent;
    }

    public AbstractParsingRule() {
    }
}

