/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.system.stub;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.regenerator.KeysRegeneratable;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.constants.SituationLevelValidation;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdsListSerializer;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.provider.TriggerProvider;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Situation.class)
public class Situation
extends LabeledStorable
implements StepContainer,
TriggerProvider,
KeysRegeneratable {
    private static final long serialVersionUID = 20240812L;
    @JsonSerialize(contentAs=IntegrationStep.class)
    @JsonDeserialize(contentAs=IntegrationStep.class)
    private List<Step> steps = new ArrayList<Step>(2);
    private List<String> labels = new ArrayList<String>(1);
    private Set<SituationEventTrigger> situationEventTriggers = Sets.newHashSetWithExpectedSize((int)3);
    private Set<OperationEventTrigger> operationEventTriggers = Sets.newHashSetWithExpectedSize((int)3);
    private Set<OperationParsingRule> parsingRules = Sets.newHashSetWithExpectedSize((int)3);
    private Map<String, String> keysToRegenerate = Maps.newHashMap();
    private SituationLevelValidation validateIncoming;
    private String bvTestcase;
    private String preScript;
    private String postScript;
    private String preValidationScript;
    private boolean ignoreErrors;

    public Situation() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only Operation objects are here")
    public Situation(Storable parent) {
        if (parent != null) {
            ((Operation)parent).getSituations().add(this);
            this.setParent(parent);
        }
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public Operation getParent() {
        return (Operation)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Operation.class)
    public void setParent(Operation parent) {
        super.setParent(parent);
    }

    @RefCopy
    @JsonSerialize(using=IdsListSerializer.class)
    public Set<ParsingRule> getParsingRules() {
        return this.parsingRules.stream().map(ParsingRule.class::cast).collect(Collectors.toSet());
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=OperationParsingRule.class)
    public void setParsingRules(Set<OperationParsingRule> parsingRules) {
        this.parsingRules = parsingRules;
    }

    public void fillParsingRules(Set<OperationParsingRule> rules) {
        StorableUtils.fillCollection(this.getParsingRules(), rules);
    }

    @Override
    public void fillSituationEventTriggers(Set<SituationEventTrigger> triggers) {
        StorableUtils.fillCollection(this.getSituationEventTriggers(), triggers);
    }

    @Override
    public void fillOperationEventTriggers(Set<OperationEventTrigger> triggers) {
        StorableUtils.fillCollection(this.getOperationEventTriggers(), triggers);
    }

    @Override
    @JsonIgnore
    public Set<EventTrigger> getAllEventTriggers() {
        Set<EventTrigger> triggers = this.getOperationEventTriggers().stream().map(EventTrigger.class::cast).collect(Collectors.toSet());
        triggers.addAll(this.getSituationEventTriggers().stream().map(EventTrigger.class::cast).collect(Collectors.toSet()));
        return triggers;
    }

    @Override
    public void fillSteps(List<Step> steps) {
        StorableUtils.fillCollection(this.getSteps(), steps);
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    @JsonIgnore
    public Mep getMep() {
        Operation operation = this.getParent();
        return operation != null ? operation.getMep() : null;
    }

    @JsonIgnore
    public IntegrationStep getIntegrationStep() {
        for (Step step : this.steps) {
            if (!(step instanceof IntegrationStep)) continue;
            return (IntegrationStep)step;
        }
        return null;
    }

    @Override
    public void fillKeysToRegenerate(@Nonnull Map<String, String> keysToRegenerate) {
        StorableUtils.fillMap(this.getKeysToRegenerate(), keysToRegenerate);
    }

    @Override
    public void addKeyToRegenerate(@Nonnull String key, @Nonnull String script) {
        this.keysToRegenerate.put(key, script);
    }

    @Override
    public void getScript(@Nonnull String key) {
        this.keysToRegenerate.get(key);
    }

    @Override
    public void removeKey(@Nonnull String key) {
        this.keysToRegenerate.remove(key);
    }

    @Override
    public void performPostCopyActions(boolean statusOff) {
        if (statusOff) {
            this.setStateForTriggers(this.getSituationEventTriggers());
            this.setStateForTriggers(this.getOperationEventTriggers());
        }
    }

    private void setStateForTriggers(Set<? extends EventTrigger> triggers) {
        if (triggers == null || triggers.isEmpty()) {
            return;
        }
        for (EventTrigger eventTrigger : triggers) {
            if (eventTrigger.getState() == TriggerState.INACTIVE) continue;
            eventTrigger.setState(TriggerState.INACTIVE);
        }
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        if (this.getIntegrationStep() != null) {
            this.getIntegrationStep().performPostImportActions(projectId, sessionId);
        }
    }

    public void setValidateIncoming(SituationLevelValidation validateIncoming) {
        this.validateIncoming = validateIncoming == null ? SituationLevelValidation.NO : validateIncoming;
    }

    @JsonIgnore
    public boolean getBooleanValidateIncoming() {
        return this.validateIncoming != null && this.validateIncoming != SituationLevelValidation.NO;
    }

    @Override
    public Storable returnSimpleParent() {
        Storable operation = super.returnSimpleParent();
        ((Operation)operation).setTransport(this.getParent().getTransport());
        ((System)operation.getParent()).getTransports().add(this.getParent().getTransport());
        return operation;
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        if (this.getIntegrationStep() != null) {
            this.getIntegrationStep().performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        }
        if (this.getOperationEventTriggers() != null) {
            this.getOperationEventTriggers().forEach(trigger -> trigger.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        }
        if (this.getSituationEventTriggers() != null) {
            this.getSituationEventTriggers().forEach(trigger -> trigger.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        }
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public Set<SituationEventTrigger> getSituationEventTriggers() {
        return this.situationEventTriggers;
    }

    @Override
    public Set<OperationEventTrigger> getOperationEventTriggers() {
        return this.operationEventTriggers;
    }

    @Override
    public Map<String, String> getKeysToRegenerate() {
        return this.keysToRegenerate;
    }

    public SituationLevelValidation getValidateIncoming() {
        return this.validateIncoming;
    }

    public String getBvTestcase() {
        return this.bvTestcase;
    }

    public String getPreScript() {
        return this.preScript;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public String getPreValidationScript() {
        return this.preValidationScript;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    @Override
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setSituationEventTriggers(Set<SituationEventTrigger> situationEventTriggers) {
        this.situationEventTriggers = situationEventTriggers;
    }

    public void setOperationEventTriggers(Set<OperationEventTrigger> operationEventTriggers) {
        this.operationEventTriggers = operationEventTriggers;
    }

    public void setKeysToRegenerate(Map<String, String> keysToRegenerate) {
        this.keysToRegenerate = keysToRegenerate;
    }

    public void setBvTestcase(String bvTestcase) {
        this.bvTestcase = bvTestcase;
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    public void setPostScript(String postScript) {
        this.postScript = postScript;
    }

    public void setPreValidationScript(String preValidationScript) {
        this.preValidationScript = preValidationScript;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }
}

