/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.transport;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.interceptor.TransportConfigurationInterceptor;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.EciConfiguration;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.holder.ActiveInterceptorHolder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.InterceptorProvider;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true, value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=TransportConfiguration.class)
public class TransportConfiguration
extends EciConfiguration
implements InterceptorProvider,
EciConfigurable {
    private static final long serialVersionUID = 20240812L;
    @JsonProperty(value="mep")
    private volatile Mep mepCache;
    private List<Interceptor> interceptors = Lists.newLinkedList();
    private System parent;

    public TransportConfiguration() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only System objects are here")
    public TransportConfiguration(Storable parent, String name, String type) {
        this.setParent((System)parent);
        ((System)parent).getTransports().add(this);
        this.setName(name);
        this.setTypeName(type);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only System objects are here")
    public TransportConfiguration(Storable parent, Map parameters) {
        this.setParent((System)parent);
        ((System)parent).getTransports().add(this);
        if (parameters != null) {
            this.putAll(parameters);
        }
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public System getParent() {
        return this.parent;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=System.class)
    public void setParent(System parent) {
        this.parent = parent;
    }

    public Mep getMep() {
        try {
            AccessTransport transport = TransportRegistryManager.getInstance().find(this.getTypeName());
            if (transport == null) {
                return this.mepCache;
            }
            this.mepCache = transport.getMep();
            return this.mepCache;
        }
        catch (NullPointerException | RemoteException | TransportException e) {
            return this.mepCache;
        }
    }

    protected Mep getMepIfNotDeployed() {
        if (this.mepCache == null) {
            return this.getMep();
        }
        return this.mepCache;
    }

    public void setMepIfNotDeployed(Mep mepIfNotDeployed) {
        this.mepCache = mepIfNotDeployed;
    }

    public String viewEndpoint(Environment environment) {
        return "";
    }

    public String viewEndpoint() {
        return "";
    }

    @JsonIgnore
    public Collection<TriggerConfiguration> getTriggers(BigInteger projectId) {
        HashSet configurations = Sets.newHashSetWithExpectedSize((int)20);
        Collection servers = CoreObjectManager.getInstance().getSpecialManager(Server.class, SearchByProjectIdManager.class).getByProjectId(projectId);
        for (Server server : servers) {
            InboundTransportConfiguration inbound = server.getInboundTransportConfiguration(this);
            if (inbound == null) continue;
            configurations.addAll(inbound.getTriggerConfigurations());
        }
        return Collections.unmodifiableCollection(configurations);
    }

    @Override
    @JsonSerialize(contentAs=TransportConfigurationInterceptor.class)
    @JsonManagedReference
    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @JsonDeserialize(contentAs=TransportConfigurationInterceptor.class)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void performPostCopyActions(boolean statusOff) {
        if (statusOff) {
            for (Interceptor interceptor : this.interceptors) {
                interceptor.setActive(false);
            }
        } else {
            ActiveInterceptorHolder.getInstance().updateActiveInterceptorHolder(this.getID(), this.interceptors);
        }
    }

    public String getEndpointPrefix() {
        try {
            AccessTransport transport = TransportRegistryManager.getInstance().find(this.getTypeName());
            if (transport == null) {
                return "";
            }
            return transport.getEndpointPrefix();
        }
        catch (NullPointerException | TransportException e) {
            return "";
        }
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getInterceptors().forEach((? super T interceptor) -> interceptor.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    @Override
    public void unbindEntityWithHierarchy() {
        this.setEciParameters(null, null);
        this.remove("ITF_TRANSPORT_LABEL");
    }
}

