/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class DecodeSaml
extends Directive {
    public String getName() {
        return "decode_saml";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String encoding;
        if (node.jjtGetNumChildren() == 1) {
            encoding = "UTF-8";
        } else if (node.jjtGetNumChildren() == 2) {
            encoding = node.jjtGetChild(1) != null ? String.valueOf(node.jjtGetChild(1).value(internalContextAdapter)) : "UTF-8";
        } else {
            this.rsvc.getLog().error((Object)"Incorrect #decode_saml directive format. Check directive parameters: Parameter#1 - content, Parameter#2 (optional)- encoding name, i.e. \"UTF-8\", \"SHIFT-JIS\"");
            writer.append("#decode_saml:incorrect parameters");
            return true;
        }
        if (node.jjtGetChild(0) != null) {
            String stringValue = String.valueOf(node.jjtGetChild(0).value(internalContextAdapter));
            writer.append(this.decodeSaml(stringValue, encoding));
        }
        return true;
    }

    public String decodeSaml(String text, String encoding) {
        try {
            byte[] decodedBytes = Base64.decodeBase64((String)URLDecoder.decode(text, encoding));
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(decodedBytes);
            InflaterInputStream in = new InflaterInputStream(bytesIn, new Inflater(true));
            byte[] buffer = new byte[decodedBytes.length];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int bytesRead = 0;
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                bytesRead = in.read(buffer);
            }
            return out.toString(encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while #decode_saml directive processing: " + e + (e.getCause() == null ? "" : "\nCaused by: " + e.getCause().toString()));
        }
    }
}

