/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class DecodeUrl
extends Directive {
    private static final String JIS = "jis";

    public String getName() {
        return "decodeUrl";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        if (node.jjtGetNumChildren() != 2) {
            this.rsvc.getLog().error((Object)"Incorrect #decodeUrl directive format. Check directive parameters: (Parameter#1 - content, Parameter#2 - encoding name, i.e. \"UTF-8\", \"SHIFT-JIS\")");
            writer.append("#err");
            return true;
        }
        String content = String.valueOf(node.jjtGetChild(0).value(internalContextAdapter));
        String encoding = String.valueOf(node.jjtGetChild(1).value(internalContextAdapter));
        writer.append(this.decodeUrl(content, encoding));
        return true;
    }

    private String decodeUrl(String content, String enc) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        try {
            if (!StringUtils.containsIgnoreCase((CharSequence)enc.trim(), (CharSequence)JIS)) {
                return URLDecoder.decode(content, enc);
            }
            String decoded = URLDecoder.decode(content, StandardCharsets.ISO_8859_1.name());
            byte[] decodedBytes = decoded.getBytes(StandardCharsets.ISO_8859_1.name());
            return new String(decodedBytes, enc);
        }
        catch (UnsupportedEncodingException e) {
            this.rsvc.getLog().error((Object)("Unsupported encoding [" + enc + "] for #decodeUrl directive"));
            return "#err";
        }
    }
}

