/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.qubership.automation.itf.core.util.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    static String configPath;
    protected static final InputStreamSupplier CLASS_PATH_RESOURCE;
    protected static final InputStreamSupplier FILE_IS;
    protected Properties properties = new Properties();

    public AbstractConfig(boolean withLoading, String fileName) {
        if (withLoading) {
            configPath = System.getProperty("config.file", fileName);
            if (!AbstractConfig.load(FILE_IS, this.properties)) {
                AbstractConfig.load(CLASS_PATH_RESOURCE, this.properties);
            }
            this.properties.putAll((Map<?, ?>)System.getProperties());
        }
    }

    protected static boolean load(InputStreamSupplier from, Properties to) {
        try (InputStreamReader reader = new InputStreamReader(from.get(), StandardCharsets.UTF_8);){
            to.load(reader);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load configuration file '{}'", (Object)from);
            return false;
        }
        LOGGER.info("Configuration file successfully loaded {}", (Object)from);
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    static {
        CLASS_PATH_RESOURCE = new InputStreamSupplier(){
            private URL lastResource = null;

            @Override
            public InputStream get() throws IOException {
                this.lastResource = Thread.currentThread().getContextClassLoader().getResource(configPath);
                if (this.lastResource == null) {
                    throw new IOException("Can not find [" + configPath + "] in classpath");
                }
                return this.lastResource.openStream();
            }

            public String toString() {
                StringBuilder b = new StringBuilder("from classpath lookup of ").append(configPath);
                if (this.lastResource != null) {
                    b.append(" [").append(this.lastResource).append("]");
                }
                return b.toString();
            }
        };
        FILE_IS = new InputStreamSupplier(){

            @Override
            public InputStream get() throws IOException {
                return new FileInputStream(configPath);
            }

            public String toString() {
                return "from " + new File(configPath).getAbsolutePath();
            }
        };
    }

    protected static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

