/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.constants;

import java.util.regex.Pattern;

public interface PropertyConstants {
    public static final Pattern FILE_DIRECTORY_PATTERN = Pattern.compile("data/(wsdl-xsd|diameter-dictionary|ei-session|dataset|keystore|fast-stub)/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(/.*)");
    public static final int FILE_DIRECTORY_PROJECT_UUID_GROUP_NUMBER = 2;
    public static final int FILE_DIRECTORY_RELATIVE_PATH_GROUP_NUMBER = 3;

    public static interface DiameterTransportConstants {
        public static final String HOST = "host";
        public static final String HOST_DESCRIPTION = "Remote host name";
        public static final String PORT = "port";
        public static final String PORT_DESCRIPTION = "Remote host port";
        public static final String DWA = "dwa";
        public static final String DWA_DESCRIPTION = "Watchdog default template";
        public static final String CONFIG_PATH = "configPath";
        public static final String CONFIG_PATH_LONG_NAME = "AVP configurations path";
        public static final String CONFIG_PATH_DESCRIPTION = "AVP configurations path (relative path, example: '/dictionary')";
        public static final String CONFIG_PATH_VALIDATE_PATTERN = "^((\\/[a-zA-Z0-9]+)+|\\/)$";
        public static final String WAIT_RESPONSE_TIMEOUT = "waitResponseTimeout";
        public static final String WAIT_RESPONSE_TIMEOUT_DESCRIPTION = "Wait response timeout. Default: 3000ms (MILLISECONDS)";
        public static final String CONNECTION_TYPE = "connectionType";
        public static final String CONNECTION_TYPE_DESCRIPTION = "TCP/SCTP connection layer";
        public static final String INTERCEPTOR_NAME = "interceptorName";
        public static final String INTERCEPTOR_NAME_DESCRIPTION = "What response you are expecting";
        public static final String MESSAGE_FORMAT_NAME = "messageFormat";
        public static final String MESSAGE_FORMAT_DESCRIPTION = "Message format";
        public static final String PROPERTIES = "properties";
        public static final String PROPERTIES_DESCRIPTION = "Properties like Origin-Host=localhost";
        public static final String CER = "CER";
        public static final String CER_DESCRIPTION = "CER template (to send automatically just after connection is opened)";
        public static final String DPA = "DPA";
        public static final String DPA_DESCRIPTION = "DPA template";
        public static final String WAIT_RESPONSE = "waitResponse";
        public static final String WAIT_RESPONSE_DESCRIPTION = "Wait response for message sent";
        public static final String CUSTOM_DPR = "customDpr";
        public static final String CUSTOM_DPR_DESCRIPTION = "Send DPR by yourself?";
        public static final String DPR = "DPR";
        public static final String DPR_DESCRIPTION = "DPR template (to send automatically just before the channel is closed)";
        public static final String SESSION_ID = "sessionID";
        public static final String SESSION_ID_DESCRIPTION = "Diameter session ID (Can be dynamic)";
        public static final String DICTIONARY_TYPE = "dictionary type";
        public static final String DICTIONARY_TYPE_DESCRIPTION = "Dictionary type";
    }

    public static interface Applicability {
        public static final String ENVIRONMENT = "Environment";
        public static final String SYSTEM = "System";
    }

    public static interface Kafka {
        public static final String BROKERS = "brokers";
        public static final String TOPIC = "topic";
        public static final String GROUP = "group";
        public static final String HEADERS = "headers";
        public static final String MESSAGE_KEY = "key";
        public static final String BROKERS_DESCRIPTION = "Brokers to consume (comma-separated list in format host:port)";
        public static final String TOPIC_DESCRIPTION = "Topics to consume (comma-separated list)";
        public static final String GROUP_DESCRIPTION = "Group of consumers";
        public static final String HEADERS_DESCRIPTION = "SomeHeader=SomeValue\nContent-Type=text/html";
        public static final String MESSAGE_KEY_DESCRIPTION = "Message Key";
    }

    public static interface Soap {
        public static final String WSDL_PATH = "wsdlPath";
        public static final String WSDL_CONTAINS_XSD = "isWsdlContains";
        public static final String REQUEST_XSD_PATH = "requestXSDPath";
        public static final String RESPONSE_XSD_PATH = "responseXSDPath";
        public static final String WSDL_PATH_DESCRIPTION = "Path to WSDL file";
        public static final String XSD_PATH_DESCRIPTION = "Path to XSD file (not required)";
    }

    public static interface Cli {
        public static final String REMOTE_IP = "remote_ip";
        public static final String CONNECTION_TYPE = "type";
        public static final String REMOTE_PORT = "remote_port";
        public static final String USER = "user";
        public static final String PASSWORD = "password";
        public static final String SSH_KEY = "ssh_key";
        public static final String WAIT_RESPONSE = "wait_response";

        public static interface Inbound {
            public static final String COMMAND_DELIMITER = "command_delimiter";
            public static final String GREETING = "greeting";
            public static final String ALLOWED_EMPTY = "empty_commands_allowed";
        }
    }

    public static interface File {
        public static final String FILE_NAME_DESCRIPTION = "File Name";
        public static final String HOST = "host";
        public static final String HOST_DESCRIPTION = "Host";
        public static final String PATH = "path";
        public static final String PATH_DESCRIPTION = "Path";
        public static final String TYPE = "type";
        public static final String TYPE_DESCRIPTION = "Protocol type";
        public static final String PRINCIPAL = "principal";
        public static final String CREDENTIALS = "credentials";
        public static final String DESTINATION_FILE_NAME = "destinationFileName";
        public static final String SSH_KEY = "ssh_key";
        public static final String SSH_KEY_DESCRIPTION = "SSH private key string (pem format only)";
    }

    public static interface Http {
        public static final String ENDPOINT_URI = "URI endpoint: /mb/test/enpoint";
        public static final String METHOD = "HTTP Method";
        public static final String RESPONSE_CODE = "Response code: 200";
        public static final String ALLOW_STATUS = "Allowed status code for response (range like '200-299' or '200-200')";
        public static final String HEADERS = "SomeHeader=SomeValue\nAuthorization=Basic some-token";
        public static final String BASE_URL = "Base URL: http://some-machine.our-company.com:6330";
        public static final String CONTENT_TYPE = "Content-Type; Default=text/html. Header overrides it.";
        public static final String PROPERTIES = "properties";
        public static final String PROPERTIES_DESCRIPTION = "Properties description";
        public static final String IS_STUB = "Is Stub: Default=No";
        public static final String CACHE_RESPONSE_FOR_SECONDS = "cacheResponseForSeconds";
        public static final String CACHE_RESPONSE_FOR_SECONDS_DESCRIPTION = "Cache response; expiry time (in seconds). Default=Empty (means: Do NOT cache a response)";
    }

    public static interface Commons {
        public static final String PRINCIPAL_DESCRIPTION = "UserName";
        public static final String AUTHENTICATION_DESCRIPTION = "Simple or empty";
        public static final String PROVIDER_URL_DESCRIPTION = "URL or empty\nURL...";
        public static final String CREDENTIALS_DESCRIPTION = "Password or empty";
        public static final String ENDPOINT_PROPERTIES = "endpointProperties";
        public static final String ENDPOINT_PROPERTIES_DESCRIPTION = "Extra Endpoint Properties (name=value pairs delimited by newlines)";
    }

    public static interface Jms {
        public static final String DESTINATION_TYPE_DESCRIPTION = "Queue or Topic";
        public static final String DESTINATION_DESCRIPTION = "For cluser:NCJMSServer_clust1/NCJMSModule!queue_xxx\nFor non cluster:NCJMSModule!queue_xxx";
        public static final String CONNECTION_FACTORY_DESCRIPTION = "jms_xxx_xxx";
        public static final String INITIAL_CONTEXT_FACTORY_DESCRIPTION = "weblogic.jndi.WLInitialContextFactory";
        public static final String ADDITIONAL_JNDI_PROPERTIES_DESCRIPTION = "aaa=bbb\nccc=ddd";
        public static final String MESSAGE_SELECTOR_DESCRIPTION = "For example: test=%A ...or empty\n";
        public static final String JMS_HEADERS_DESCRIPTION = "aaa=bbb\nccc=ddd";
        public static final String RECOVERY_INTERVAL_DESCRIPTION = "Time between reconnection attempts in milliseconds";
        public static final String MAX_ATTEMPTS_DESCRIPTION = "Total maximum reconnection attempts: unlimited or numerical value";
    }
}

