/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.eds.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsCommandListener;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsConnectionPoolListener;
import org.bson.UuidRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

@Configuration
@ConditionalOnProperty(name={"eds.gridfs.enabled"}, havingValue="true")
public class ItfGridFsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ItfGridFsConfiguration.class);
    @Value(value="${eds.gridfs.host}")
    private String host;
    @Value(value="${eds.gridfs.port}")
    private String port;
    @Value(value="${eds.gridfs.database}")
    private String database;
    @Value(value="${eds.gridfs.username}")
    private String user;
    @Value(value="${eds.gridfs.password}")
    private String password;

    @Bean
    public GridFsTemplate gridFsTemplate(MongoDatabaseFactory mongoDatabaseFactory, MappingMongoConverter mappingMongoConverter) {
        GridFsTemplate gridFsTemplate = new GridFsTemplate(mongoDatabaseFactory, (MongoConverter)mappingMongoConverter);
        log.info("GridFsTemplate has been created!");
        return gridFsTemplate;
    }

    @Bean
    public MongoDatabaseFactory mongoDatabaseFactory(MeterRegistry meterRegistry) {
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().addCommandListener((CommandListener)new MongoMetricsCommandListener(meterRegistry)).applyToConnectionPoolSettings(builder -> builder.addConnectionPoolListener((ConnectionPoolListener)new MongoMetricsConnectionPoolListener(meterRegistry)).build()).applyConnectionString(new ConnectionString(this.getUri())).uuidRepresentation(UuidRepresentation.JAVA_LEGACY).build());
        return new SimpleMongoClientDatabaseFactory(mongoClient, this.database);
    }

    @Bean
    public DbRefResolver dbRefResolver(MongoDatabaseFactory mongoDatabaseFactory) {
        return new DefaultDbRefResolver(mongoDatabaseFactory);
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter(DbRefResolver dbRefResolver) {
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setSimpleTypeHolder(SimpleTypeHolder.DEFAULT);
        mappingContext.afterPropertiesSet();
        return new MappingMongoConverter(dbRefResolver, (MappingContext)mappingContext);
    }

    private String getUri() {
        StringBuilder sb = new StringBuilder();
        sb.append("mongodb://").append(this.user).append(":").append(this.password).append("@").append(this.host).append(":").append(Integer.parseInt(this.port)).append("/?authSource=").append(this.database);
        return sb.toString();
    }
}

