/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.eds.service;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.qubership.automation.itf.core.util.eds.ExternalStorageService;
import org.qubership.automation.itf.core.util.eds.configuration.ItfGridFsConfiguration;
import org.qubership.automation.itf.core.util.eds.model.FileInfo;
import org.qubership.automation.itf.core.util.eds.repository.ItfGridFsRepository;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.eds.service.EdsMetaInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={ItfGridFsConfiguration.class})
public class GridFsService
implements ExternalStorageService {
    private final ItfGridFsRepository gridFsRepository;

    @Autowired
    public GridFsService(@Qualifier(value="ItfGridFsRepository") ItfGridFsRepository gridFsRepository) {
        this.gridFsRepository = gridFsRepository;
    }

    @Override
    public Set<FileInfo> getFilesInfoByProject(UUID uuid) throws IOException {
        return this.getFilesInfoByMetadata(this.createMetadataParamsMap(EdsMetaInfo.PROJECT_UUID.getStringValue(), uuid));
    }

    @Override
    public Set<FileInfo> getKeyStoreFileInfo() throws IOException {
        return this.getFilesInfoByMetadata(this.createMetadataParamsMap(EdsMetaInfo.CONTENT_TYPE.getStringValue(), EdsContentType.KEYSTORE.getStringValue()));
    }

    @Override
    public Set<FileInfo> getFilesInfoByMetadataMapParams(Map<String, Object> metadataParams) throws IOException {
        return this.getFilesInfoByMetadata(metadataParams);
    }

    @Override
    public FileInfo getFileInfo(ObjectId objectId) throws IOException {
        return this.createFileInfo(this.gridFsRepository.findById(objectId));
    }

    @Override
    public ObjectId store(String contentType, UUID projectUuid, String userName, UUID userId, String filePath, String fileName, InputStream fileInputStream) {
        Map<String, Object> map = this.createMetadataParamsMap(EdsMetaInfo.FILE_PATH.getStringValue(), filePath);
        map.put(EdsMetaInfo.CONTENT_TYPE.getStringValue(), contentType);
        if (projectUuid != null) {
            map.put(EdsMetaInfo.PROJECT_UUID.getStringValue(), projectUuid);
        }
        this.gridFsRepository.delete(map, fileName);
        map.put(EdsMetaInfo.USER_NAME.getStringValue(), userName);
        map.put(EdsMetaInfo.USER_ID.getStringValue(), userId);
        return this.gridFsRepository.store(map, fileName, fileInputStream);
    }

    @Override
    public void delete(String contentType, UUID projectUuid, String filePath, String fileName) {
        Map<String, Object> map = this.createMetadataParamsMap(EdsMetaInfo.FILE_PATH.getStringValue(), filePath);
        map.put(EdsMetaInfo.CONTENT_TYPE.getStringValue(), contentType);
        if (projectUuid != null) {
            map.put(EdsMetaInfo.PROJECT_UUID.getStringValue(), projectUuid);
        }
        this.gridFsRepository.delete(map, fileName);
    }

    private Set<FileInfo> getFilesInfoByMetadata(Map<String, Object> metadataParams) throws IOException {
        HashSet<FileInfo> result = new HashSet<FileInfo>();
        for (GridFSFile gridFsFile : this.gridFsRepository.findByMetadata(metadataParams)) {
            FileInfo fileInfo = this.createFileInfo(gridFsFile);
            if (fileInfo == null) continue;
            result.add(fileInfo);
        }
        return result;
    }

    private FileInfo createFileInfo(GridFSFile gridFsFile) throws IOException {
        Document metadata;
        if (gridFsFile != null && (metadata = gridFsFile.getMetadata()) != null) {
            GridFsResource gridFsResource = this.gridFsRepository.getResource(gridFsFile);
            return new FileInfo(gridFsFile.getObjectId(), gridFsFile.getFilename(), (String)metadata.get((Object)EdsMetaInfo.FILE_PATH.getStringValue(), String.class), gridFsFile.getLength(), metadata.getString((Object)EdsMetaInfo.CONTENT_TYPE.getStringValue()), (UUID)metadata.get((Object)EdsMetaInfo.PROJECT_UUID.getStringValue(), UUID.class), (String)metadata.get((Object)EdsMetaInfo.USER_NAME.getStringValue(), String.class), (UUID)metadata.get((Object)EdsMetaInfo.USER_ID.getStringValue(), UUID.class), gridFsFile.getUploadDate(), gridFsResource.getInputStream());
        }
        return null;
    }

    private Map<String, Object> createMetadataParamsMap(String key, Object value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(key, value);
        return params;
    }
}

