/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.ei.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.exception.NoSuchManagerException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportedDataCache {
    public static final String SIMPLE_PARENT_MARKER = "#SimpleParent#";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportedDataCache.class);
    private final Map<BigInteger, Storable> importedDataCache = new ConcurrentHashMap<BigInteger, Storable>();
    private BigInteger projectId;

    public synchronized Storable deserialize(JsonParser p, BigInteger sessionId) throws IOException {
        JsonNode treeNode = (JsonNode)p.getCodec().readTree(p);
        BigInteger id = new BigInteger(treeNode.get("id").asText());
        boolean jsonIsSimpleParent = this.checkJsonSimpleParent(treeNode.get("description"));
        Storable storable = this.importedDataCache.get(id);
        if (storable == null || !jsonIsSimpleParent && storable.getDescription() != null && storable.getDescription().equals(SIMPLE_PARENT_MARKER)) {
            storable = this.getDeserializedEntity(p, treeNode, id);
            if (storable.getParent() == null && "ROOT".equals(storable.getName())) {
                storable = storable.findRootObject(this.projectId);
                this.importedDataCache.put((BigInteger)storable.getID(), storable);
            } else {
                storable.performPostImportActions(this.projectId, sessionId);
            }
        }
        return storable;
    }

    private Storable getDeserializedEntity(JsonParser p, JsonNode treeNode, BigInteger entityId) {
        String clazz = treeNode.get("type").asText();
        try {
            Class<Storable> storableClass = Class.forName(clazz).asSubclass(Storable.class);
            return (Storable)((ObjectMapper)p.getCodec()).readValue(treeNode.toString(), storableClass);
        }
        catch (JsonProcessingException | ClassNotFoundException e) {
            LOGGER.warn(String.format("Class for type=%s of entity with id=%s was not found.", clazz, entityId));
            throw new IllegalArgumentException(e);
        }
    }

    public Storable getById(BigInteger id) {
        return this.importedDataCache.get(id);
    }

    public ArrayList<Storable> getStorablesByClassName(String className) {
        ArrayList<Storable> storables = new ArrayList<Storable>();
        for (Storable storable : this.importedDataCache.values()) {
            if (!storable.getClass().getName().equals(className)) continue;
            storables.add(storable);
        }
        return storables;
    }

    public void put(BigInteger storableId, Storable storable) {
        this.importedDataCache.put(storableId, storable);
    }

    public ArrayList<Storable> getAll() {
        ArrayList<Storable> storables = new ArrayList<Storable>();
        for (Storable next : this.importedDataCache.values()) {
            try {
                CoreObjectManager.getInstance().getManager(next.getClass());
                storables.add(next);
            }
            catch (NoSuchManagerException noSuchManagerException) {}
        }
        return storables;
    }

    private boolean checkJsonSimpleParent(JsonNode node) {
        if (node == null || node.isNull() || !node.isTextual()) {
            return false;
        }
        return node.asText().equals(SIMPLE_PARENT_MARKER);
    }

    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }
}

