/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.finder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.util.config.Config;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class InterceptorFinder {
    @Nonnull
    public static Set<Class<? extends Interceptor>> find(@Nonnull String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("The package of interceptors is not specified");
        }
        Reflections reflections = new Reflections(path, new Scanner[0]);
        return reflections.getSubTypesOf(Interceptor.class);
    }

    @Nonnull
    public static Set<Class<? extends Interceptor>> find() {
        HashSet<Class<? extends Interceptor>> interceptors = new HashSet<Class<? extends Interceptor>>(10);
        Collection<Object> interceptorPaths = Config.getConfig().getByPrefix("interceptor").getValues();
        if (interceptorPaths != null && !interceptorPaths.isEmpty()) {
            interceptorPaths.forEach(value -> interceptors.addAll(InterceptorFinder.find((String)value)));
        }
        return interceptors;
    }
}

