/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.helper;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.LoggerFactory;

public class FailTimeOut {
    public static long getTimeout(BigInteger projectId) {
        try {
            return TxExecutor.execute(() -> {
                Map<String, String> props = CoreObjectManager.getInstance().getManager(StubProject.class).getById(projectId).getStorableProp();
                TimeUnit configuredTimeUnit = TimeUnit.valueOf(props.getOrDefault("tc.timeout.fail.timeunit", "MINUTES"));
                long configuredValue = Long.parseLong(props.getOrDefault("tc.timeout.fail", "20"));
                return configuredTimeUnit.toMillis(configuredValue);
            }, TxExecutor.readOnlyTransaction());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Config.class).warn("FailTimeOut.getTimeout({}) exception: ", (Object)projectId, (Object)e);
            TimeUnit timeUnit = TimeUnit.valueOf("MINUTES");
            return timeUnit.toMillis(Long.parseLong("20"));
        }
    }
}

