/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.holder;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.TemplateInterceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.TransportConfigurationInterceptor;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.holder.InterceptorHolder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveInterceptorHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveInterceptorHolder.class);
    private Map<String, Map<String, Interceptor>> activeInterceptors = new HashMap<String, Map<String, Interceptor>>();
    private static final ActiveInterceptorHolder INSTANCE = new ActiveInterceptorHolder();

    private ActiveInterceptorHolder() {
    }

    public static ActiveInterceptorHolder getInstance() {
        return INSTANCE;
    }

    public void fillActiveInterceptorHolder() {
        try {
            TxExecutor.executeUnchecked(() -> {
                Map<String, Map<String, Class<?>>> registeredInterceptors = InterceptorHolder.getInstance().getInterceptors();
                if (!registeredInterceptors.isEmpty()) {
                    this.getActiveInterceptorsFromProvider(TemplateInterceptor.class, registeredInterceptors);
                    this.getActiveInterceptorsFromProvider(TransportConfigurationInterceptor.class, registeredInterceptors);
                }
                return null;
            }, TxExecutor.nestedReadOnlyTransaction());
        }
        catch (Exception e) {
            LOGGER.error("Can't register active interceptors", (Throwable)e);
        }
    }

    public void clearActiveInterceptorHolder() {
        this.activeInterceptors.clear();
    }

    public Map<String, Map<String, Interceptor>> getActiveInterceptors() {
        return this.activeInterceptors;
    }

    public void updateActiveInterceptorHolder(Object interceptorProvideId, Collection<Interceptor> interceptors) {
        for (Interceptor interceptor : interceptors) {
            if (!interceptor.isActive()) continue;
            this.addInterceptorData(interceptorProvideId, interceptor);
        }
    }

    private void getActiveInterceptorsFromProvider(Class interceptorClass, Map<String, Map<String, Class<?>>> registeredInterceptors) {
        Collection thisClassInterceptors;
        ObjectManager manager;
        CoreObjectManagerService coreObjectManager = CoreObjectManager.getInstance();
        if (coreObjectManager != null && coreObjectManager.getManagerFactory() != null && (manager = coreObjectManager.getManager(interceptorClass)) != null && (thisClassInterceptors = manager.getAll()) != null && !thisClassInterceptors.isEmpty()) {
            for (Interceptor interceptor : thisClassInterceptors) {
                if (!interceptor.isActive() || !ActiveInterceptorHolder.interceptorIsRegistered(registeredInterceptors, interceptor)) continue;
                this.addInterceptorData(interceptor.getParent().getID(), interceptor);
            }
        }
    }

    private void addInterceptorData(Object interceptorProviderId, Interceptor interceptor) {
        Map<String, Interceptor> interceptors = this.activeInterceptors.get(interceptorProviderId.toString());
        if (interceptors == null) {
            interceptors = new LinkedHashMap<String, Interceptor>();
            interceptors.put(interceptor.getID().toString(), interceptor);
            this.activeInterceptors.put(interceptorProviderId.toString(), interceptors);
        } else {
            interceptors.put(interceptor.getID().toString(), interceptor);
        }
    }

    private static boolean interceptorIsRegistered(Map<String, Map<String, Class<?>>> registeredInterceptors, Interceptor interceptor) {
        Map<String, Class<?>> interceptorsInfo = registeredInterceptors.get(interceptor.getTransportName());
        if (interceptorsInfo == null || interceptorsInfo.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Class<?>> interceptorInfo : interceptorsInfo.entrySet()) {
            if (!interceptorInfo.getValue().getName().equals(interceptor.getTypeName())) continue;
            return true;
        }
        return false;
    }
}

