/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.loader.base;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.util.loader.ChildFirstURLClassLoader;
import org.qubership.automation.itf.core.util.loader.base.Loader;
import org.qubership.automation.itf.core.util.loader.helper.LoaderHelper;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoader<T>
implements Loader<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);
    protected static String LIB;
    protected static String PATH_PATTERN;
    private final Map<String, ClassLoader> classLoaderHolder = Maps.newHashMapWithExpectedSize((int)10);
    private ClassLoader libClassLoader;

    protected abstract Class<T> getGenericType();

    @Override
    public void load(String path, String customLibPath) {
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("File or directory by path '" + path + "' doesn't exist");
        }
        try {
            boolean isCustomLibPathSet = !StringUtils.isBlank((CharSequence)customLibPath);
            List<URL[]> urlsList = this.parseURLArrayByTransportType(LoaderHelper.getUrls(file));
            for (URL[] urls : urlsList) {
                ChildFirstURLClassLoader libClassLoader = isCustomLibPathSet ? (ChildFirstURLClassLoader)this.loadLibClassLoader(path + LIB + "/" + this.parseUrlName(urls[0]), path + LIB, customLibPath + "/" + this.parseUrlName(urls[0]), customLibPath) : (ChildFirstURLClassLoader)this.loadLibClassLoader(path + LIB + "/" + this.parseUrlName(urls[0]), path + LIB);
                ChildFirstURLClassLoader classLoader = new ChildFirstURLClassLoader(urls, (ClassLoader)libClassLoader);
                this.addClassesIntoClassLoaderHolder(this.find(classLoader), classLoader);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to convert file path '" + path + "' to url.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load libs for '" + file.getName() + "' file.", e);
        }
    }

    @Override
    public void cleanClassLoaders() {
        this.classLoaderHolder.clear();
    }

    public void setLibLoader(ClassLoader classLoader) {
        this.libClassLoader = classLoader;
    }

    private Set<Class<? extends T>> find(ClassLoader classLoader) {
        Reflections reflections = new Reflections(new Object[]{"org.qubership", classLoader});
        HashSet classes = Sets.newHashSet();
        reflections.getSubTypesOf(this.getGenericType()).forEach(clazz -> {
            if (!Modifier.isAbstract(clazz.getModifiers())) {
                classes.add(clazz);
            }
        });
        this.validateClasses(classes);
        return classes;
    }

    protected abstract void validateClasses(Set<Class<? extends T>> var1);

    protected void addClassesIntoClassLoaderHolder(Set<Class<? extends T>> classes, ClassLoader classLoader) {
        for (Class<T> clazz : classes) {
            this.classLoaderHolder.put(clazz.getName(), classLoader);
        }
    }

    private ClassLoader loadLibClassLoader(String ... paths) throws IOException {
        if (Objects.isNull(this.libClassLoader)) {
            ArrayList urls = Lists.newArrayList();
            for (String path : paths) {
                if (StringUtils.isBlank((CharSequence)path)) continue;
                File fileForLib = new File(path);
                if (!fileForLib.exists()) {
                    log.warn("File or directory by path '{}' doesn't exist", (Object)path);
                    continue;
                }
                urls.addAll(Arrays.asList(LoaderHelper.getUrls(fileForLib)));
            }
            return new ChildFirstURLClassLoader(LoaderHelper.toArray(urls), this.getClass().getClassLoader());
        }
        return this.libClassLoader;
    }

    private List<URL[]> parseURLArrayByTransportType(URL[] urls) {
        HashMap cache = Maps.newHashMap();
        for (URL url : urls) {
            String urlName = this.parseUrlName(url);
            List urls1 = (List)cache.get(urlName);
            if (Objects.isNull(urls1)) {
                cache.put(urlName, Lists.newArrayList());
            }
            ((List)cache.get(urlName)).add(url);
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : cache.entrySet()) {
            list.add(((List)entry.getValue()).toArray(new URL[0]));
        }
        return list;
    }

    private String parseUrlName(URL url) {
        String urlPath = url.getPath();
        Pattern compile = Pattern.compile(PATH_PATTERN, 8);
        Matcher matcher = compile.matcher(urlPath);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    @Override
    public Map<String, ClassLoader> getClassLoaderHolder() {
        return this.classLoaderHolder;
    }
}

