/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.loader.helper;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoaderHelper {
    private static final String jar = ".jar";
    private static final String zip = ".zip";
    private static final String clazz = ".class";

    public static URL[] getUrls(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles(pathname -> {
            String name = pathname.getName();
            return name.endsWith(jar) || name.endsWith(zip) || name.endsWith(clazz);
        })) != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file1 : files) {
                if (file1.isDirectory()) continue;
                if (file1.getName().endsWith(jar)) {
                    urls.addAll(LoaderHelper.getJarLibs(file1));
                }
                urls.add(file1.toURI().toURL());
            }
            return LoaderHelper.toArray(urls);
        }
        return new URL[]{file.toURI().toURL()};
    }

    public static URL[] toArray(List<URL> urls) {
        return urls.toArray(new URL[urls.size()]);
    }

    private static Collection<URL> getJarLibs(File jarFile) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = new URL("jar:file:" + jarFile.getPath() + "!/");
        result.add(url);
        return result;
    }
}

