/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.parser;

import com.google.gson.Gson;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.qubership.atp.common.utils.regex.TimeoutRegexCharSequence;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ParsingRuleType {
    REGEX{
        private static final int maxRegexTimeoutSeconds = 60;

        @Override
        public String toString() {
            return "Regex";
        }

        @Override
        public MessageParameter parse(Message message, ParsingRule parsingRule) {
            MessageParameter.Builder builder = MessageParameter.build(parsingRule.getParamName(), parsingRule).multiple(parsingRule.getMultiple()).setAutosave(parsingRule.getAutosave());
            if (!StringUtils.isEmpty((CharSequence)message.getText())) {
                Pattern pattern = Pattern.compile(parsingRule.getParsedExpression());
                Matcher matcher = pattern.matcher((CharSequence)new TimeoutRegexCharSequence((CharSequence)message.getText(), 60));
                while (matcher.find()) {
                    if (matcher.groupCount() > 0) {
                        builder.multipleValue(matcher.group(1));
                    } else {
                        builder.multipleValue(matcher.group());
                    }
                    if (parsingRule.getMultiple().booleanValue()) continue;
                    break;
                }
            }
            return builder.get();
        }
    }
    ,
    XPATH{
        private final transient ThreadLocal<XMLOutputter> xmlOutputter = ThreadLocal.withInitial(XMLOutputter::new);

        @Override
        public String toString() {
            return "Xpath";
        }

        @Override
        public MessageParameter parse(Message message, ParsingRule parsingRule) {
            MessageParameter.Builder builder = MessageParameter.build(parsingRule.getParamName(), parsingRule).multiple(parsingRule.getMultiple()).setAutosave(parsingRule.getAutosave());
            Element element = (Element)message.getContent().get();
            XPathExpression xpathExpr = XPathFactory.instance().compile(parsingRule.getParsedExpression());
            try {
                List evaluate = xpathExpr.evaluate((Object)element);
                for (Object o : evaluate) {
                    if (o instanceof Element) {
                        this.xmlOutputter.get().setFormat(Format.getPrettyFormat());
                        builder.multipleValue(this.xmlOutputter.get().outputString((Element)o));
                    } else if (o instanceof Text) {
                        builder.multipleValue(((Content)o).getValue());
                    } else if (o instanceof Attribute) {
                        builder.multipleValue(((Attribute)o).getValue());
                    } else {
                        builder.multipleValue(o.toString());
                    }
                    if (parsingRule.getMultiple().booleanValue()) continue;
                    break;
                }
                return builder.get();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Failed applying xpath. Probably xPaths is incorrect. ParsingRule '%s', at %s", parsingRule.getParamName(), parsingRule.getParsingRulePath()), e);
            }
        }
    }
    ,
    REGEX_URI{

        @Override
        public String toString() {
            return "Regex URI";
        }

        @Override
        public MessageParameter parse(Message message, ParsingRule parsingRule) {
            Pattern pattern;
            Matcher matcher;
            MessageParameter.Builder builder = MessageParameter.build(parsingRule.getParamName(), parsingRule).multiple(parsingRule.getMultiple()).setAutosave(parsingRule.getAutosave());
            if (message.getConnectionProperties().get("uriParams") != null && (matcher = (pattern = Pattern.compile(parsingRule.getParsedExpression())).matcher((String)message.getConnectionProperties().get("uriParams"))).find()) {
                this.buildResult(parsingRule, matcher, builder);
            }
            return builder.get();
        }
    }
    ,
    JSON_PATH{

        @Override
        public String toString() {
            return "JSON Path";
        }

        @Override
        public MessageParameter parse(Message message, ParsingRule parsingRule) {
            MessageParameter.Builder builder = MessageParameter.build(parsingRule.getParamName(), parsingRule).multiple(parsingRule.getMultiple()).setAutosave(parsingRule.getAutosave());
            try {
                Object document = message.getContent().get();
                Object parsingResult = JsonPath.read(document, (String)parsingRule.getParsedExpression(), (Predicate[])new Predicate[0]);
                if (parsingRule.getMultiple().booleanValue()) {
                    if (parsingResult instanceof List) {
                        ((List)parsingResult).forEach(entry -> builder.multipleValue(this.jsonEntry2String(entry)));
                    } else {
                        builder.multipleValue(this.jsonEntry2String(parsingResult));
                    }
                } else {
                    Object obj;
                    List listResult;
                    String result = parsingResult instanceof List ? ((listResult = (List)parsingResult).isEmpty() ? "" : (Objects.isNull(obj = listResult.get(0)) ? "" : this.jsonEntry2String(obj))) : (Objects.isNull(parsingResult) ? "" : this.jsonEntry2String(parsingResult));
                    builder.multipleValue(result);
                }
                return builder.get();
            }
            catch (InvalidJsonException ex) {
                return builder.get();
            }
            catch (PathNotFoundException ex) {
                return builder.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed parsing JsonPath. Probably JsonPath expression is incorrect. ParsingRule '%s', at %s", parsingRule.getParamName(), parsingRule.getParsingRulePath()), e);
            }
        }

        private String jsonEntry2String(Object entry) {
            if (entry instanceof List || entry instanceof Map) {
                return new Gson().toJson(entry);
            }
            return String.valueOf(entry);
        }
    }
    ,
    REGEX_HEADER{

        @Override
        public String toString() {
            return "Regex Header";
        }

        @Override
        public MessageParameter parse(Message message, ParsingRule parsingRule) {
            MessageParameter.Builder builder = MessageParameter.build(parsingRule.getParamName(), parsingRule).multiple(parsingRule.getMultiple()).setAutosave(parsingRule.getAutosave());
            Map<String, Object> headers = message.getHeaders();
            if (Objects.isNull(headers)) {
                return builder.get();
            }
            String parsedExpression = parsingRule.getParsedExpression();
            if (!parsedExpression.contains("/")) {
                String requiredHeaderName = parsedExpression;
                if (requiredHeaderName.equals("*")) {
                    builder.multipleValue(this.headers2ConfigurationHeadersString(headers));
                } else {
                    Object headerValue = headers.get(requiredHeaderName);
                    if (Objects.nonNull(headerValue)) {
                        if (headerValue instanceof List) {
                            for (Object elem : (List)headerValue) {
                                builder.multipleValue(Objects.toString(elem));
                                if (parsingRule.getMultiple().booleanValue()) continue;
                                break;
                            }
                        } else {
                            builder.multipleValue(Objects.toString(headerValue));
                        }
                    }
                }
                return builder.get();
            }
            String[] splitExpression = parsedExpression.split("/", 2);
            String requiredHeaderName = splitExpression[0];
            String expression = splitExpression[1];
            if (headers.get(requiredHeaderName) == null) {
                return builder.get();
            }
            Pattern pattern = Pattern.compile(expression);
            Matcher matcher = pattern.matcher(Objects.toString(headers.get(requiredHeaderName)));
            if (matcher.find()) {
                this.buildResult(parsingRule, matcher, builder);
            }
            return builder.get();
        }
    };

    private static final Logger log;

    public abstract String toString();

    public abstract MessageParameter parse(Message var1, ParsingRule var2);

    public static ParsingRuleType from(String value) {
        for (ParsingRuleType type : ParsingRuleType.values()) {
            if (!type.toString().equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("Undefined type of parsing rule '" + value + "' expected: " + Arrays.toString((Object[])ParsingRuleType.values()));
    }

    protected void buildResult(ParsingRule parsingRule, Matcher matcher, MessageParameter.Builder builder) {
        if (parsingRule.getMultiple().booleanValue()) {
            for (int groupIndex = 1; groupIndex <= matcher.groupCount(); ++groupIndex) {
                builder.multipleValue(matcher.group(groupIndex));
            }
        } else if (matcher.groupCount() > 0) {
            builder.multipleValue(matcher.group(1));
        } else {
            builder.multipleValue("");
        }
    }

    protected String headers2ConfigurationHeadersString(Map<String, Object> headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (entry.getKey().startsWith("Camel")) continue;
            if (entry.getValue() instanceof List) {
                for (Object elem : (List)entry.getValue()) {
                    sb.append(entry.getKey()).append("=").append(elem).append("\n");
                }
                continue;
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    static {
        log = LoggerFactory.getLogger(ParsingRuleType.class);
    }
}

