/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.transport.service.report;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.qubership.automation.itf.core.util.transport.service.report.ReportAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAdapterStorage {
    private static final ReportAdapterStorage INSTANCE = new ReportAdapterStorage();
    private static final List<ReportAdapter> STORAGE = Lists.newArrayListWithExpectedSize((int)5);
    public static final Logger LOGGER = LoggerFactory.getLogger(ReportAdapterStorage.class);

    public static ReportAdapterStorage getInstance() {
        return INSTANCE;
    }

    public void init() {
        for (Class clazz : Reflection.getReflections().getSubTypesOf(ReportAdapter.class)) {
            try {
                STORAGE.add((ReportAdapter)clazz.newInstance());
            }
            catch (Exception e) {
                LOGGER.error("Failed registration of adapter", (Throwable)e);
            }
        }
    }

    public List<ReportAdapter> getAdapters() {
        return Collections.unmodifiableList(STORAGE);
    }

    public void terminateAll() {
        for (ReportAdapter adapter : STORAGE) {
            adapter.terminate();
        }
    }
}

