/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (7.6.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.macros.clients.api;

import org.qubership.atp.macros.core.clients.api.dto.macros.EvaluationRequestDto;
import org.qubership.atp.macros.core.clients.api.dto.macros.MacrosDto;
import org.qubership.atp.macros.core.clients.api.dto.macros.MacrosPageDto;
import org.qubership.atp.macros.core.clients.api.dto.macros.ScriptEngineDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-30T11:09:09.485886002Z[Etc/UTC]", comments = "Generator version: 7.6.0")
@Validated
@Tag(name = "macro-controller", description = "Macro Controller")
public interface MacroControllerApi {

    /**
     * POST /api/v1/macros : Create a new macros
     *
     * @param macrosDto  (optional)
     * @return Successful response (status code 200)
     *         or Created (status code 201)
     *         or Bad request (status code 400)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Create a new macros",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response"),
            @ApiResponse(responseCode = "201", description = "Created", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "400", description = "Bad request"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/macros",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    
    ResponseEntity<Void> create(
        @Parameter(name = "MacrosDto", description = "") @Valid @RequestBody(required = false) MacrosDto macrosDto
    );


    /**
     * DELETE /api/v1/macros/{uuid} : Delete specified macros
     *
     * @param uuid uuid (required)
     * @return Successful response (status code 200)
     *         or No Content (status code 204)
     *         or Bad request (status code 400)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Macros not found (status code 404)
     */
    @Operation(
        operationId = "delete",
        summary = "Delete specified macros",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "400", description = "Bad request"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Macros not found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/v1/macros/{uuid}"
    )
    
    ResponseEntity<Void> delete(
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /api/v1/macros/evaluate : Evaluate specified content
     *
     * @param body  (optional)
     * @return Successful response (status code 200)
     *         or Created (status code 201)
     *         or Bad request (status code 400)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "evaluate",
        summary = "Evaluate specified content",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "400", description = "Bad request"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/macros/evaluate",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    
    ResponseEntity<String> evaluate(
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) String body
    );


    /**
     * POST /api/v1/macros/evaluate/context : Evaluate specified content with context
     *
     * @param evaluationRequestDto  (optional)
     * @return Successful response (status code 200)
     *         or Created (status code 201)
     *         or Bad request (status code 400)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "evaluateWithContext",
        summary = "Evaluate specified content with context",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "400", description = "Bad request"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/v1/macros/evaluate/context",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    
    ResponseEntity<String> evaluateWithContext(
        @Parameter(name = "EvaluationRequestDto", description = "") @Valid @RequestBody(required = false) EvaluationRequestDto evaluationRequestDto
    );


    /**
     * GET /api/v1/macros/all : Get all available macros
     *
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findAll",
        summary = "Get all available macros",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = MacrosDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/all",
        produces = { "application/json" }
    )
    
    ResponseEntity<List<MacrosDto>> findAll(
        
    );


    /**
     * GET /api/v1/macros/all/project/{uuid} : Get all available macros for specified project (including global)
     *
     * @param uuid uuid (required)
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findAllByProject",
        summary = "Get all available macros for specified project (including global)",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = MacrosDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/all/project/{uuid}",
        produces = { "application/json" }
    )
    
    ResponseEntity<List<MacrosDto>> findAllByProject(
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /api/v1/macros/project/{uuid}/all : Get all macros for specified project
     *
     * @param uuid uuid (required)
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findAllByProjectId",
        summary = "Get all macros for specified project",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = MacrosDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/project/{uuid}/all",
        produces = { "application/json" }
    )
    
    ResponseEntity<List<MacrosDto>> findAllByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /api/v1/macros/project/{uuid} : Get specified page of all available macros for specified project
     *
     * @param uuid uuid (required)
     * @param page page (optional)
     * @param size size (optional)
     * @param sort sort (optional)
     * @param direction direction (optional)
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findByProjectId",
        summary = "Get specified page of all available macros for specified project",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = MacrosPageDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/project/{uuid}",
        produces = { "application/json" }
    )
    
    ResponseEntity<MacrosPageDto> findByProjectId(
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "page", description = "page", in = ParameterIn.QUERY) @Valid @RequestParam(value = "page", required = false) Integer page,
        @Parameter(name = "size", description = "size", in = ParameterIn.QUERY) @Valid @RequestParam(value = "size", required = false) Integer size,
        @Parameter(name = "sort", description = "sort", in = ParameterIn.QUERY) @Valid @RequestParam(value = "sort", required = false) String sort,
        @Parameter(name = "direction", description = "direction", in = ParameterIn.QUERY) @Valid @RequestParam(value = "direction", required = false) String direction
    );


    /**
     * GET /api/v1/macros/global : Get all available global macros
     *
     * @param page page (optional)
     * @param size size (optional)
     * @param sort sort (optional)
     * @param direction direction (optional)
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findGlobal",
        summary = "Get all available global macros",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = MacrosPageDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/global",
        produces = { "application/json" }
    )
    
    ResponseEntity<MacrosPageDto> findGlobal(
        @Parameter(name = "page", description = "page", in = ParameterIn.QUERY) @Valid @RequestParam(value = "page", required = false) Integer page,
        @Parameter(name = "size", description = "size", in = ParameterIn.QUERY) @Valid @RequestParam(value = "size", required = false) Integer size,
        @Parameter(name = "sort", description = "sort", in = ParameterIn.QUERY) @Valid @RequestParam(value = "sort", required = false) String sort,
        @Parameter(name = "direction", description = "direction", in = ParameterIn.QUERY) @Valid @RequestParam(value = "direction", required = false) String direction
    );


    /**
     * GET /api/v1/macros/all-nontechnical/project/{uuid} : Get all non technical available macros for specified project (including global)
     *
     * @param uuid uuid (required)
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findNonTechnicalMacrosByProject",
        summary = "Get all non technical available macros for specified project (including global)",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = MacrosDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/all-nontechnical/project/{uuid}",
        produces = { "application/json" }
    )
    
    ResponseEntity<List<MacrosDto>> findNonTechnicalMacrosByProject(
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /api/v1/macros/engines : Get all available script engines
     *
     * @return Successful response (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEngines",
        summary = "Get all available script engines",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = ScriptEngineDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v1/macros/engines",
        produces = { "application/json" }
    )
    
    ResponseEntity<List<ScriptEngineDto>> getEngines(
        
    );


    /**
     * PUT /api/v1/macros/{uuid} : Update specified macros
     *
     * @param uuid uuid (required)
     * @param macrosDto  (optional)
     * @return Successful response (status code 200)
     *         or Created (status code 201)
     *         or Bad request (status code 400)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "update",
        summary = "Update specified macros",
        tags = { "macro-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Successful response", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = MacrosDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "400", description = "Bad request"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/v1/macros/{uuid}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    
    ResponseEntity<MacrosDto> update(
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "MacrosDto", description = "") @Valid @RequestBody(required = false) MacrosDto macrosDto
    );

}
