/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.converter;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class Date2OffsetDateTimeConverter
implements ConditionalConverter<Date, OffsetDateTime> {
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        if (Date.class.isAssignableFrom(sourceType) && OffsetDateTime.class.isAssignableFrom(destinationType)) {
            return ConditionalConverter.MatchResult.FULL;
        }
        return ConditionalConverter.MatchResult.NONE;
    }

    public OffsetDateTime convert(MappingContext<Date, OffsetDateTime> context) {
        if (context.getSource() == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(((Date)context.getSource()).toInstant(), ZoneOffset.UTC);
    }
}

