/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.macros.core.clients.api.dto.macros.EvaluationRequestDto;
import org.qubership.atp.macros.core.clients.api.dto.macros.MacrosDto;
import org.qubership.atp.macros.core.clients.api.dto.macros.MacrosPageDto;
import org.qubership.atp.macros.core.clients.api.dto.macros.ScriptEngineDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="macro-controller", description="Macro Controller")
public interface MacroControllerApi {
    @Operation(operationId="create", summary="Create a new macros", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response"), @ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/macros"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Void> create(@Parameter(name="MacrosDto", description="") @Valid @RequestBody(required=false) MacrosDto var1);

    @Operation(operationId="delete", summary="Delete specified macros", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Macros not found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/macros/{uuid}"})
    public ResponseEntity<Void> delete(@Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="evaluate", summary="Evaluate specified content", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/macros/evaluate"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> evaluate(@Parameter(name="body", description="") @Valid @RequestBody(required=false) String var1);

    @Operation(operationId="evaluateWithContext", summary="Evaluate specified content with context", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/macros/evaluate/context"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<String> evaluateWithContext(@Parameter(name="EvaluationRequestDto", description="") @Valid @RequestBody(required=false) EvaluationRequestDto var1);

    @Operation(operationId="findAll", summary="Get all available macros", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MacrosDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/all"}, produces={"application/json"})
    public ResponseEntity<List<MacrosDto>> findAll();

    @Operation(operationId="findAllByProject", summary="Get all available macros for specified project (including global)", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MacrosDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/all/project/{uuid}"}, produces={"application/json"})
    public ResponseEntity<List<MacrosDto>> findAllByProject(@Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="findAllByProjectId", summary="Get all macros for specified project", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MacrosDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/project/{uuid}/all"}, produces={"application/json"})
    public ResponseEntity<List<MacrosDto>> findAllByProjectId(@Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="findByProjectId", summary="Get specified page of all available macros for specified project", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", schema=@Schema(implementation=MacrosPageDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/project/{uuid}"}, produces={"application/json"})
    public ResponseEntity<MacrosPageDto> findByProjectId(@Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var1, @Parameter(name="page", description="page", in=ParameterIn.QUERY) @Valid @RequestParam(value="page", required=false) Integer var2, @Parameter(name="size", description="size", in=ParameterIn.QUERY) @Valid @RequestParam(value="size", required=false) Integer var3, @Parameter(name="sort", description="sort", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String var4, @Parameter(name="direction", description="direction", in=ParameterIn.QUERY) @Valid @RequestParam(value="direction", required=false) String var5);

    @Operation(operationId="findGlobal", summary="Get all available global macros", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", schema=@Schema(implementation=MacrosPageDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/global"}, produces={"application/json"})
    public ResponseEntity<MacrosPageDto> findGlobal(@Parameter(name="page", description="page", in=ParameterIn.QUERY) @Valid @RequestParam(value="page", required=false) Integer var1, @Parameter(name="size", description="size", in=ParameterIn.QUERY) @Valid @RequestParam(value="size", required=false) Integer var2, @Parameter(name="sort", description="sort", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String var3, @Parameter(name="direction", description="direction", in=ParameterIn.QUERY) @Valid @RequestParam(value="direction", required=false) String var4);

    @Operation(operationId="findNonTechnicalMacrosByProject", summary="Get all non technical available macros for specified project (including global)", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MacrosDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/all-nontechnical/project/{uuid}"}, produces={"application/json"})
    public ResponseEntity<List<MacrosDto>> findNonTechnicalMacrosByProject(@Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getEngines", summary="Get all available script engines", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ScriptEngineDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/macros/engines"}, produces={"application/json"})
    public ResponseEntity<List<ScriptEngineDto>> getEngines();

    @Operation(operationId="update", summary="Update specified macros", tags={"macro-controller"}, responses={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", schema=@Schema(implementation=MacrosDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/v1/macros/{uuid}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<MacrosDto> update(@Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var1, @Parameter(name="MacrosDto", description="") @Valid @RequestBody(required=false) MacrosDto var2);
}

