/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.processor;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.exception.ThrowingErrorListener;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.parser.antlr4.MacrosLexer;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.qubership.atp.macros.core.processor.CtxEvalException;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.qubership.atp.macros.core.processor.MacrosVisitorImpl;
import org.qubership.atp.macros.core.registry.MacroRegistry;

public class EvaluatorImpl
implements Evaluator {
    private final MacroRegistry registry;
    private final MacrosCalculator calculator;
    private MacrosLexer macrosLexer = null;
    private MacrosParser macrosParser = null;

    @Override
    @Nullable
    public <T extends AbstractContext<T>> String evaluate(@Nonnull String input, @Nonnull T context) {
        String result = input;
        int triesCount = 10;
        while (true) {
            if (triesCount-- == -1) {
                throw new CtxEvalException("Macros constantly reevaluates, please check for recursion. Only 10 reevaluates are allowed.", context);
            }
            if (StringUtils.isEmpty((String)result)) {
                return result;
            }
            if ((context = this.oneTimeEvaluate(result, context.reset())) == null) {
                return result;
            }
            String newResult = context.getResultOnEvaluationEnd();
            if (newResult == null) {
                return null;
            }
            if (newResult.equals(result)) {
                return result;
            }
            result = newResult;
        }
    }

    @Override
    public <T extends AbstractContext<T>> String evaluate(@Nonnull Macros macros, @Nullable List<String> args, @Nonnull T context) {
        return this.calculator.calculate(macros, args, context);
    }

    private <T extends AbstractContext<T>> T oneTimeEvaluate(@Nonnull String input, @Nonnull T context) {
        return this.visitMacro(input, new MacrosVisitorImpl<T>(this.registry, this, context));
    }

    private <T> T visitMacro(@Nonnull String input, @Nonnull ParseTreeVisitor<T> visitor) {
        CodePointCharStream inputStream = CharStreams.fromString((String)input);
        if (this.macrosLexer == null) {
            this.macrosLexer = new MacrosLexer((CharStream)inputStream);
            this.macrosLexer.removeErrorListeners();
            this.macrosLexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.ERROR_LISTENER);
            this.macrosParser = new MacrosParser((TokenStream)new CommonTokenStream((TokenSource)this.macrosLexer));
        } else {
            this.macrosLexer.setInputStream((IntStream)inputStream);
            this.macrosParser.setTokenStream((TokenStream)new CommonTokenStream((TokenSource)this.macrosLexer));
            this.macrosParser.removeErrorListeners();
            this.macrosParser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.ERROR_LISTENER);
        }
        MacrosParser.BodyContext context = this.macrosParser.body();
        return (T)visitor.visit((ParseTree)context);
    }

    public EvaluatorImpl(MacroRegistry registry, MacrosCalculator calculator) {
        this.registry = registry;
        this.calculator = calculator;
    }
}

