/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.processor;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.macros.core.processor.AbstractContext;

public class DataKey<T> {
    private static final Map<String, DataKey> ourDataKeyIndex = new HashMap<String, DataKey>();
    private final String myName;

    protected DataKey(@Nonnull String name) {
        this.myName = name;
    }

    public static <T> DataKey<T> create(@Nonnull String name) {
        DataKey<T> key = ourDataKeyIndex.get(name);
        if (key != null) {
            return key;
        }
        key = new DataKey<T>(name);
        ourDataKeyIndex.put(name, key);
        return key;
    }

    @Nonnull
    public String getName() {
        return this.myName;
    }

    public final boolean is(String dataId) {
        return this.myName.equals(dataId);
    }

    @Nullable
    public T get(@Nonnull AbstractContext<?> dataContext) {
        return (T)dataContext.getData(this);
    }

    @Nonnull
    public T getNonnull(@Nonnull AbstractContext dataContext) {
        T result = this.get(dataContext);
        Preconditions.checkNotNull(result, (String)"Value for [%s] should not be null in [%s]", (Object)this.getName(), (Object)dataContext);
        return result;
    }

    public T set(@Nonnull AbstractContext<?> dataContext, @Nonnull T data) {
        return dataContext.setData(this, data);
    }

    public T remove(@Nonnull AbstractContext<?> dataContext) {
        return (T)dataContext.removeData(this);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataKey dataKey = (DataKey)o;
        return Objects.equals(this.myName, dataKey.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myName);
    }
}

