/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.macros.core.model.AbstractEntity;
import org.qubership.atp.macros.core.model.MacrosParameter;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonIgnoreProperties(ignoreUnknown=true)
public class Macros
extends AbstractEntity {
    private static final long serialVersionUID = -8448338543183169090L;
    private static final String UNKNOWN_PROJECT_UUID = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
    @Indexed
    private UUID projectUuid;
    private String engine;
    private String content;
    private boolean technical;
    protected List<MacrosParameter> parameters = new ArrayList<MacrosParameter>();

    @Nonnull
    public String getProjectId() {
        if (null != this.getProjectUuid()) {
            return this.getProjectUuid().toString();
        }
        return UNKNOWN_PROJECT_UUID;
    }

    @Override
    public UUID getParentId() {
        return this.projectUuid;
    }

    public UUID getProjectUuid() {
        return this.projectUuid;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isTechnical() {
        return this.technical;
    }

    public List<MacrosParameter> getParameters() {
        return this.parameters;
    }

    public void setProjectUuid(UUID projectUuid) {
        this.projectUuid = projectUuid;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTechnical(boolean technical) {
        this.technical = technical;
    }

    public void setParameters(List<MacrosParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Macros)) {
            return false;
        }
        Macros other = (Macros)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTechnical() != other.isTechnical()) {
            return false;
        }
        UUID this$projectUuid = this.getProjectUuid();
        UUID other$projectUuid = other.getProjectUuid();
        if (this$projectUuid == null ? other$projectUuid != null : !((Object)this$projectUuid).equals(other$projectUuid)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<MacrosParameter> this$parameters = this.getParameters();
        List<MacrosParameter> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Macros;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTechnical() ? 79 : 97);
        UUID $projectUuid = this.getProjectUuid();
        result = result * 59 + ($projectUuid == null ? 43 : ((Object)$projectUuid).hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<MacrosParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Macros(projectUuid=" + this.getProjectUuid() + ", engine=" + this.getEngine() + ", content=" + this.getContent() + ", technical=" + this.isTechnical() + ", parameters=" + this.getParameters() + ")";
    }
}

