/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import java.util.Set;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.provider.impl.DisableSecurityUserProvider;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.common.logging.interceptor.RestTemplateLogInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@Profile(value={"disable-security"})
public class DisableSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${atp-auth.headers.content-security-policy:default-src 'self' *some-domain.some-cloud}")
    private String contentSecurityPolicy;

    @Bean(value={"entityAccess"})
    public PolicyEnforcement entityAccessEnforcement() {
        return new PolicyEnforcement(){

            public boolean checkAccess(Set<UUID> projectIdSet, String action) {
                return true;
            }

            public boolean checkAccess(UUID projectId, Operation action) {
                return true;
            }

            public boolean checkAccess(String entityName, UUID projectId, Operation action) {
                return true;
            }

            public boolean checkAccess(String entityName, Set<UUID> projectIdSet, Operation action) {
                return true;
            }

            public boolean checkAccess(String entityName, Set<UUID> projectIdSet, String action) {
                return true;
            }

            public boolean checkAccess(String entityName, UUID projectId, UUID objectId, Operation operation) {
                return true;
            }

            public boolean checkAccess(String entityName, UUID projectId, Set<UUID> objectIds, Operation operation) {
                return true;
            }

            public boolean isAdmin() {
                return true;
            }

            public boolean isSupport() {
                return true;
            }

            public boolean isAuthenticated() {
                return true;
            }

            public boolean checkPoliciesForOperation(Project project, Operation operation) {
                return true;
            }

            public boolean checkPoliciesForOperation(String entityName, Project project, Operation operation) {
                return true;
            }
        };
    }

    @Bean(value={"relayRestTemplate"})
    public RestTemplate relayRestTemplate(RestTemplateLogInterceptor restTemplateLogInterceptor) {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        restTemplate.getInterceptors().add(restTemplateLogInterceptor);
        return restTemplate;
    }

    @Bean(value={"relayWebClient"})
    public WebClient relayWebClient() {
        return WebClient.builder().build();
    }

    @Bean(value={"userInfoProvider"})
    public Provider<UserInfo> userInfoProvider() {
        return new DisableSecurityUserProvider();
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.headers().defaultsDisabled().xssProtection().xssProtectionEnabled(false).and().contentSecurityPolicy(this.contentSecurityPolicy).and().and()).authorizeRequests().antMatchers(new String[]{"/**"})).permitAll();
    }
}

