/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

@Configuration
public class HttpClientsConfiguration {
    @Bean
    public HttpClient sslHttpClient(SSLContext sslContext) {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
    }

    @Bean
    public ClientHttpRequestFactory sslRequestFactory(HttpClient sslHttpClient) {
        HttpComponentsClientHttpRequestFactory sslRequestFactory = new HttpComponentsClientHttpRequestFactory();
        sslRequestFactory.setHttpClient(sslHttpClient);
        return sslRequestFactory;
    }

    @Bean
    @ConditionalOnProperty(value={"atp-auth.ssl.certificate.verify"}, havingValue="false", matchIfMissing=true)
    public SSLContext ignoreVerifySslContext() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        return SSLContexts.custom().loadTrustMaterial(null, (x, y) -> true).build();
    }

    @Bean
    @ConditionalOnProperty(value={"atp-auth.ssl.certificate.verify"}, matchIfMissing=false)
    public SSLContext selfSignedSslContext(Provider<TrustManagerFactory> trustManagerFactoryProvider) throws Exception {
        TrustManagerFactory trustManagerFactory = (TrustManagerFactory)trustManagerFactoryProvider.get();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        return context;
    }
}

