/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.permissions;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.Group;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.entities.Operations;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.atp.auth.springbootstarter.entities.Role;
import org.qubership.atp.auth.springbootstarter.holders.DataContextHolder;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.auth.springbootstarter.services.UserGroupService;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class EntityAccessEnforcement
implements PolicyEnforcement {
    private static final Logger log = LoggerFactory.getLogger(EntityAccessEnforcement.class);
    private final UsersService usersService;
    private final UserGroupService userGroupService;
    private final DataContextHolder<Set<String>> userRolesContextHolder;
    private final String serviceName;
    private static final String PROJECT_PERMISSIONS = "atp-catalogue-Project";
    private static final String DEFAULT_PERMISSIONS = "DEFAULT";

    @Autowired
    public EntityAccessEnforcement(UsersService usersService, UserGroupService userGroupService, DataContextHolder<Set<String>> userRolesContextHolder, String serviceName) {
        this.usersService = usersService;
        this.userGroupService = userGroupService;
        this.userRolesContextHolder = userRolesContextHolder;
        this.serviceName = serviceName;
    }

    public boolean checkAccess(Set<UUID> projectIdSet, String action) {
        UUID projectId;
        boolean isAccess = false;
        if (this.isAdmin()) {
            return true;
        }
        if (projectIdSet == null) {
            return false;
        }
        Iterator<UUID> iterator = projectIdSet.iterator();
        while (iterator.hasNext() && (isAccess = this.checkAccess(projectId = iterator.next(), action))) {
        }
        return isAccess;
    }

    public boolean checkAccess(UUID projectId, Operation operation) {
        if (this.isAdmin()) {
            return true;
        }
        if (projectId == null) {
            return false;
        }
        Group group = this.userGroupService.getUserGroupByProjectId(projectId);
        return this.checkPolicies(operation, group, projectId, "");
    }

    public boolean checkAccess(String entityName, UUID projectId, Operation operation) {
        if (this.isAdmin()) {
            return true;
        }
        if (projectId == null) {
            return false;
        }
        Group group = this.userGroupService.getUserGroupByProjectId(projectId);
        return this.checkPolicies(operation, group, projectId, entityName);
    }

    public boolean checkAccess(String entityName, Set<UUID> projectIdSet, Operation action) {
        UUID projectId;
        boolean isAccess = false;
        if (this.isAdmin()) {
            return true;
        }
        if (projectIdSet == null) {
            return false;
        }
        Iterator<UUID> iterator = projectIdSet.iterator();
        while (iterator.hasNext() && (isAccess = this.checkAccess(entityName, projectId = iterator.next(), action))) {
        }
        return isAccess;
    }

    public boolean checkAccess(String entityName, Set<UUID> projectIdSet, String action) {
        UUID projectId;
        boolean isAccess = false;
        if (this.isAdmin()) {
            return true;
        }
        if (projectIdSet == null) {
            return false;
        }
        Iterator<UUID> iterator = projectIdSet.iterator();
        while (iterator.hasNext() && (isAccess = this.checkAccess(entityName, projectId = iterator.next(), action))) {
        }
        return isAccess;
    }

    public boolean checkAccess(String entityName, UUID projectId, UUID objectId, Operation operation) {
        String objectName;
        if (this.isAdmin()) {
            return true;
        }
        if (!this.checkAccess(entityName, projectId, operation)) {
            log.debug("User has no rights to the project - access denied");
            return false;
        }
        if (Objects.isNull(objectId)) {
            log.debug("ObjectId is null. Checking access to the object is not required - access is granted");
            return true;
        }
        Optional<UUID> userIdOpt = this.userGroupService.getUserId();
        if (!userIdOpt.isPresent()) {
            log.debug("User is not defined - access denied");
            return false;
        }
        UUID userId = userIdOpt.get();
        Map<String, Map<UUID, Operations>> permissions = this.usersService.getPermissionsByObjectId(entityName, projectId, objectId);
        Map<UUID, Operations> assignedUsers = permissions.get(objectName = this.usersService.getObjectName(entityName, objectId));
        if (Objects.isNull(assignedUsers)) {
            log.debug("Object with name: {} and id {} not found - access denied", (Object)entityName, (Object)objectId);
            return false;
        }
        Operations ops = assignedUsers.get(userId);
        if (Objects.isNull(ops)) {
            log.debug("User with id {} not assigned to object (entity: {}, id: {}) - access denied", new Object[]{userId, entityName, objectId});
            return false;
        }
        return ops.isOperationAvailable(operation);
    }

    public boolean checkAccess(String entityName, UUID projectId, Set<UUID> objectIds, Operation operation) {
        if (this.isAdmin()) {
            return true;
        }
        if (!this.checkAccess(entityName, projectId, operation)) {
            log.debug("User has no rights to the project - access denied");
            return false;
        }
        if (CollectionUtils.isEmpty(objectIds)) {
            log.debug("ObjectIds are empty or null. Checking access to the object is not required - access is granted");
            return true;
        }
        Optional<UUID> userIdOpt = this.userGroupService.getUserId();
        if (!userIdOpt.isPresent()) {
            log.debug("User is not defined - access denied");
            return false;
        }
        UUID userId = userIdOpt.get();
        Map<String, Map<UUID, Operations>> permissions = this.usersService.getObjectPermissionsForService(projectId);
        return objectIds.stream().allMatch(objectId -> {
            String objectName = this.usersService.getObjectName(entityName, (UUID)objectId);
            Map assignedUsers = (Map)permissions.get(objectName);
            if (Objects.isNull(assignedUsers)) {
                log.debug("Object with name: {} and id {} not found - access denied", (Object)entityName, objectId);
                return false;
            }
            Operations ops = (Operations)assignedUsers.get(userId);
            if (Objects.isNull(ops)) {
                log.debug("User with id {} not assigned to object (entity: {}, id: {}) - access denied", new Object[]{userId, entityName, objectId});
                return false;
            }
            return ops.isOperationAvailable(operation);
        });
    }

    public boolean isAdmin() {
        return this.hasRole(Role.ATP_ADMIN);
    }

    public boolean isSupport() {
        return this.hasRole(Role.ATP_SUPPORT);
    }

    private boolean hasRole(Role role) {
        Optional userRoles = this.userRolesContextHolder.get();
        if (userRoles.isPresent() && !((Set)userRoles.get()).isEmpty()) {
            return ((Set)userRoles.get()).stream().anyMatch(userRole -> role.name().equalsIgnoreCase((String)userRole));
        }
        return false;
    }

    public boolean isAuthenticated() {
        return this.userGroupService.getUserId().isPresent();
    }

    private boolean checkAccessForProject(String entityName, Project project, Operation operation) {
        if (this.isAdmin()) {
            return true;
        }
        Group group = this.userGroupService.getUserGroupByProject(project);
        return this.checkPolicies(operation, group, project, entityName);
    }

    private boolean checkPolicies(Operation operation, Group group, Project project, String entityName) {
        if (project.getPermissions() == null) {
            return this.checkPolicies(operation, group, project.getUuid(), entityName);
        }
        Map permissionsInGroup = project.getPermissions().getPermissionsByGroup(group);
        return this.checkPolicies(operation, permissionsInGroup, entityName);
    }

    private boolean checkPolicies(Operation operation, Group group, UUID projectId, String entityName) {
        Map permissionsInGroup = this.usersService.getPermissionsByProjectId(projectId).getPermissionsByGroup(group);
        return this.checkPolicies(operation, permissionsInGroup, entityName);
    }

    private boolean checkPolicies(Operation operation, Map<String, Operations> permissionsInGroup, String entityName) {
        if (permissionsInGroup == null) {
            return false;
        }
        if (entityName.isEmpty()) {
            return this.checkPoliciesForOperation(permissionsInGroup, operation);
        }
        return this.checkPoliciesForOperationInEntity(permissionsInGroup, entityName, operation);
    }

    private boolean checkPoliciesForOperation(Map<String, Operations> permissions, Operation operation) {
        Operations operations = permissions.get(PROJECT_PERMISSIONS);
        if (operations == null && (operations = permissions.get(DEFAULT_PERMISSIONS)) == null) {
            return false;
        }
        return operations.isOperationAvailable(operation);
    }

    public boolean checkPoliciesForOperation(Project project, Operation operation) {
        return this.checkAccessForProject("", project, operation);
    }

    public boolean checkPoliciesForOperation(String entityName, Project project, Operation operation) {
        return this.checkAccessForProject(entityName, project, operation);
    }

    private boolean checkPoliciesForOperationInEntity(Map<String, Operations> permissions, String entityName, Operation operation) {
        Operations operations = permissions.get(this.serviceName + "-" + entityName);
        if (operations == null) {
            return this.checkPoliciesForOperation(permissions, operation);
        }
        return operations.isOperationAvailable(operation);
    }
}

