/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import org.keycloak.adapters.springsecurity.KeycloakConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@KeycloakConfiguration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Profile(value={"default"})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter
implements WebSecurityConfigurer<WebSecurity> {
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${atp-auth.headers.content-security-policy:default-src 'self' *}")
    private String contentSecurityPolicy;

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/assets/**"})).antMatchers(HttpMethod.OPTIONS, new String[]{"/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.headers().xssProtection().xssProtectionEnabled(false).and().contentSecurityPolicy(this.contentSecurityPolicy).and().frameOptions().sameOrigin().and()).csrf().disable()).authorizeRequests().antMatchers(new String[]{"/ws/api"})).permitAll().antMatchers(new String[]{"/api/public/**"})).permitAll().antMatchers(new String[]{"/rest/deployment/**"})).permitAll().antMatchers(new String[]{"/*/api/**", "/api/**"})).authenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }
}

