/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import java.util.HashMap;
import java.util.UUID;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.TopicBuilder;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@ConditionalOnProperty(name={"kafka.enable"}, havingValue="true")
public class KafkaConfig {
    @Value(value="${kafka.service.entities.topic}")
    private String kafkaServiceEntitiesTopic;
    @Value(value="${kafka.service.entities.topic.partitions:1}")
    private int kafkaServiceEntitiesTopicPartitions;
    @Value(value="${kafka.service.entities.topic.replicas:3}")
    private short kafkaServiceEntitiesTopicReplicationFactor;
    @Value(value="${spring.kafka.producer.bootstrap-servers}")
    private String kafkaServers;

    @Bean
    public KafkaTemplate<UUID, String> kafkaServiceEntitiesTemplate() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaServers);
        props.put("key.serializer", UUIDSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        return new KafkaTemplate((ProducerFactory)new DefaultKafkaProducerFactory(props));
    }

    @Bean
    public NewTopic serviceEntitiesTopic() {
        return TopicBuilder.name((String)this.kafkaServiceEntitiesTopic).partitions(this.kafkaServiceEntitiesTopicPartitions).replicas((int)this.kafkaServiceEntitiesTopicReplicationFactor).build();
    }
}

