/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Profile(value={"default"})
public class SecurityConfiguration {
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${atp-auth.headers.content-security-policy:default-src 'self' *}")
    private String contentSecurityPolicy;

    public void configureHttpSecurity(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).headers(headers -> headers.defaultsDisabled().contentSecurityPolicy(policy -> policy.policyDirectives(this.contentSecurityPolicy))).authorizeHttpRequests(registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(new String[]{"/**"})).permitAll());
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        this.configureHttpSecurity(http);
        return (SecurityFilterChain)http.build();
    }
}

