/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.qubership.atp.auth.springbootstarter.entities.ObjectPermissions;
import org.qubership.atp.auth.springbootstarter.entities.Operations;
import org.qubership.atp.auth.springbootstarter.entities.Permissions;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.atp.auth.springbootstarter.entities.ServiceEntities;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.services.client.UsersFeignClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@CacheConfig(cacheNames={"auth_projects", "auth_objects"})
public class UsersService {
    private final UsersFeignClient usersFeignClient;
    private final KafkaTemplate<UUID, String> kafkaTemplate;
    @Value(value="${kafka.service.entities.topic:service_entities}")
    private String topicName;
    @Value(value="${spring.application.name}")
    private String serviceName;

    @Cacheable(value={"auth_projects"})
    public Project getUsersByProject(UUID projectId) {
        Project project = new Project();
        project.setUuid(projectId);
        project.setLeads(new HashSet());
        project.setQaTaEngineers(new HashSet());
        project.setDevOpsEngineers(new HashSet());
        project.setAtpRunners(new HashSet());
        project.setAtpSupports(new HashSet());
        project.setPermissions(new Permissions());
        return project;
    }

    public Permissions getPermissionsByProjectId(UUID projectId) {
        Project project = this.getUsersByProject(projectId);
        return project.getPermissions();
    }

    public void sendEntities(ServiceEntities serviceEntities) {
    }

    @Cacheable(value={"auth_objects"})
    public Map<String, Map<UUID, Operations>> getPermissionsByObjectId(String entityName, UUID projectId, UUID objectId) {
        return new HashMap<String, Map<UUID, Operations>>();
    }

    public Map<String, Map<UUID, Operations>> getObjectPermissionsForService(UUID projectId) {
        return new HashMap<String, Map<UUID, Operations>>();
    }

    public List<UserInfo> getUsersInfoByProjectId(UUID projectId, List<UUID> userIds) {
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
        userIds.forEach(uuid -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(uuid);
            userInfo.fillStubbedProperties();
            userInfoList.add(userInfo);
        });
        return userInfoList;
    }

    public ObjectPermissions saveObjectPermissions(String entityName, UUID projectId, UUID objectId, Map<UUID, Operations> assignedUsers) {
        HashMap<String, Map<UUID, Operations>> permissions = new HashMap<String, Map<UUID, Operations>>();
        permissions.put(objectId.toString(), assignedUsers);
        return new ObjectPermissions(UUID.randomUUID(), projectId, this.serviceName, permissions);
    }

    public ObjectPermissions grantAllPermissions(String entityName, UUID projectId, UUID objectId, List<UUID> assignedUsers) throws Exception {
        HashMap<UUID, Operations> permissions = new HashMap<UUID, Operations>();
        assignedUsers.forEach(userId -> permissions.put((UUID)userId, new Operations(true, true, true, true, true, true, true)));
        return this.saveObjectPermissions(entityName, projectId, objectId, permissions);
    }

    public void deleteObjectPermissions(String entityName, UUID projectId, UUID objectId) {
    }

    public void deleteObjectPermissionsBulk(String entityName, UUID projectId, List<UUID> objectIds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithoutUserToken(Callable<T> callable) throws Exception {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(null);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
    }

    private void runWithoutUserToken(Runnable runnable) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(null);
        try {
            runnable.run();
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
    }

    public String getObjectName(String entityName, UUID objectId) {
        return String.format("%s-%s-%s", this.serviceName, entityName, objectId);
    }

    private List<String> getObjectNames(String entityName, List<UUID> objectId) {
        return objectId.stream().map(id -> String.format("%s-%s-%s", this.serviceName, entityName, id)).collect(Collectors.toList());
    }

    public UsersService(UsersFeignClient usersFeignClient, KafkaTemplate<UUID, String> kafkaTemplate) {
        this.usersFeignClient = usersFeignClient;
        this.kafkaTemplate = kafkaTemplate;
    }
}

