/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.entities;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operations
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Operations.class);
    private static final long serialVersionUID = -6807095207165209809L;
    private boolean create;
    private boolean read;
    private boolean update;
    private boolean delete;
    private boolean execute;
    private boolean lock;
    private boolean unlock;

    public boolean isOperationAvailable(Operation operation) {
        boolean permissionForOperation = false;
        try {
            Field field = this.getClass().getDeclaredField(operation.toString());
            field.setAccessible(true);
            permissionForOperation = (Boolean)field.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("Failed to get permission for operation \"{}\". {}", (Object)operation, (Object)e.getMessage());
        }
        return permissionForOperation;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean isExecute() {
        return this.execute;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setExecute(boolean execute) {
        this.execute = execute;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operations)) {
            return false;
        }
        Operations other = (Operations)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCreate() != other.isCreate()) {
            return false;
        }
        if (this.isRead() != other.isRead()) {
            return false;
        }
        if (this.isUpdate() != other.isUpdate()) {
            return false;
        }
        if (this.isDelete() != other.isDelete()) {
            return false;
        }
        if (this.isExecute() != other.isExecute()) {
            return false;
        }
        if (this.isLock() != other.isLock()) {
            return false;
        }
        return this.isUnlock() == other.isUnlock();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Operations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCreate() ? 79 : 97);
        result = result * 59 + (this.isRead() ? 79 : 97);
        result = result * 59 + (this.isUpdate() ? 79 : 97);
        result = result * 59 + (this.isDelete() ? 79 : 97);
        result = result * 59 + (this.isExecute() ? 79 : 97);
        result = result * 59 + (this.isLock() ? 79 : 97);
        result = result * 59 + (this.isUnlock() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Operations(create=" + this.isCreate() + ", read=" + this.isRead() + ", update=" + this.isUpdate() + ", delete=" + this.isDelete() + ", execute=" + this.isExecute() + ", lock=" + this.isLock() + ", unlock=" + this.isUnlock() + ")";
    }

    public Operations(boolean create, boolean read, boolean update, boolean delete, boolean execute, boolean lock, boolean unlock) {
        this.create = create;
        this.read = read;
        this.update = update;
        this.delete = delete;
        this.execute = execute;
        this.lock = lock;
        this.unlock = unlock;
    }

    public Operations() {
    }
}

