/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.exceptions;

import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.NOT_FOUND, reason="ATP-0001")
public class AtpEntityNotFoundException
extends AtpException {
    public static final String DEFAULT_MESSAGE = "Failed to find %s entity";
    public static final String DEFAULT_ID_MESSAGE = "Failed to find %s with id: %s";
    public static final String DEFAULT_REF_ID_MESSAGE = "Failed to find %s by %s: %s";

    public AtpEntityNotFoundException(String entity) {
        super(String.format(DEFAULT_MESSAGE, entity));
    }

    public AtpEntityNotFoundException(String entity, Object id) {
        super(String.format(DEFAULT_ID_MESSAGE, entity, id));
    }

    public AtpEntityNotFoundException(String entity, String refField, Object refFieldValue) {
        super(String.format(DEFAULT_REF_ID_MESSAGE, entity, refField, refFieldValue));
    }
}

