/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Logger;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import org.qubership.atp.auth.springbootstarter.feign.exception.FeignClientExceptionErrorDecoder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class FeignConfiguration {
    private volatile HttpMessageConverters feignHttpMessageConverters;

    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorDecoder.class})
    public FeignClientExceptionErrorDecoder commonFeignErrorDecoder() {
        return new FeignClientExceptionErrorDecoder();
    }

    @Bean
    @Primary
    public Encoder feignEncoder(@Qualifier(value="feignClientObjectMapper") ObjectMapper feignClientObjectMapper) {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(feignClientObjectMapper);
        ObjectFactory objectFactory = () -> this.lambda$feignEncoder$0((HttpMessageConverter)jacksonConverter);
        return new SpringEncoder(objectFactory);
    }

    @Bean
    @Qualifier(value="feignClientObjectMapper")
    public ObjectMapper feignClientObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    private /* synthetic */ HttpMessageConverters lambda$feignEncoder$0(HttpMessageConverter jacksonConverter) throws BeansException {
        if (this.feignHttpMessageConverters == null) {
            this.feignHttpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{jacksonConverter});
        }
        return this.feignHttpMessageConverters;
    }
}

