/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import org.keycloak.adapters.KeycloakConfigResolver;
import org.qubership.atp.auth.springbootstarter.security.oauth2.client.config.AuthChannelInterceptor;
import org.qubership.atp.auth.springbootstarter.services.BearerTokenWebSocketAuthenticator;
import org.qubership.atp.auth.springbootstarter.utils.BearerTokenStompExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@Profile(value={"default"})
@Order(value=-2147483549)
@EnableWebMvc
@EnableWebSecurity
public class WebSocketAuthenticationSecurityConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private KeycloakConfigResolver keycloakConfigResolver;
    @Autowired
    private BearerTokenStompExtractor bearerTokenStompExtractor;

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new AuthChannelInterceptor(new BearerTokenWebSocketAuthenticator(this.keycloakConfigResolver), this.bearerTokenStompExtractor)});
    }
}

