/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.interceptors;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

public class MdcHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    List<String> businessIds;

    public MdcHttpRequestInterceptor(List<String> businessIds) {
        this.businessIds = businessIds;
    }

    private String convertIdNameToHeader(String idName) {
        return "X-" + Arrays.stream(idName.split("(?=\\p{Upper})")).map(StringUtils::capitalize).collect(Collectors.joining("-"));
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.businessIds.forEach(idName -> {
            if (MDC.get((String)idName) != null) {
                request.getHeaders().add(this.convertIdNameToHeader((String)idName), MDC.get((String)idName));
            }
        });
        return execution.execute(request, body);
    }
}

