/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.auditing.handler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.common.auditing.db.mongo.auditor.Auditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class IsNewAwareCustomAuditingHandler
extends IsNewAwareAuditingHandler {
    private static final Logger log = LoggerFactory.getLogger(IsNewAwareCustomAuditingHandler.class);
    private final PersistentEntities entities;
    private final Provider<UserInfo> provider;
    private final Auditor auditor;

    public IsNewAwareCustomAuditingHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, Provider<UserInfo> provider, Auditor auditor) {
        super(PersistentEntities.of((MappingContext[])new MappingContext[]{mappingContext}));
        this.entities = PersistentEntities.of((MappingContext[])new MappingContext[]{mappingContext});
        this.provider = provider;
        this.auditor = auditor;
    }

    public Object markAudited(Object object) {
        Assert.notNull((Object)object, (String)"Source object must not be null");
        if (this.isDateAuditObject(object)) {
            try {
                this.setAuditorAware(this.auditor);
                PropertyDescriptor pd = new PropertyDescriptor("createdWhen", object.getClass());
                Method getterCreatedWhen = pd.getReadMethod();
                if (getterCreatedWhen.invoke(object, new Object[0]) == null) {
                    this.markCreated(object);
                }
            }
            catch (Exception e) {
                log.error("Cannot set created when and created by fields", (Throwable)e);
            }
            this.markModified(object);
        }
        return object;
    }

    private boolean isDateAuditObject(Object object) {
        Assert.notNull((Object)object, (String)"Source object must not be null");
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor("createdWhen", object.getClass());
            return propertyDescriptor.getName().equals("createdWhen");
        }
        catch (Exception e) {
            log.debug("This is not audit object: {}", object, (Object)e);
            return false;
        }
    }
}

