/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.utils.regex;

import org.qubership.atp.common.utils.regex.TimeoutRegexException;

public class TimeoutRegexCharSequence
implements CharSequence {
    private final CharSequence inner;
    private final int timeoutMillis;
    private final long timeoutTime;

    public TimeoutRegexCharSequence(CharSequence inner, int timeout) {
        this.inner = inner;
        this.timeoutMillis = timeout * 1000;
        this.timeoutTime = System.currentTimeMillis() + (long)this.timeoutMillis;
    }

    @Override
    public char charAt(int index) {
        if (System.currentTimeMillis() > this.timeoutTime) {
            String message = String.format("Timeout occurred after %s ms while processing regular expression %s.", this.timeoutMillis, this.inner);
            throw new TimeoutRegexException(message);
        }
        return this.inner.charAt(index);
    }

    @Override
    public int length() {
        return this.inner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new TimeoutRegexCharSequence(this.inner.subSequence(start, end), this.timeoutMillis);
    }

    @Override
    public String toString() {
        return this.inner.toString();
    }
}

