/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.benchmarks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.model.utils.TestData;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=3, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=3, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=3)
public class Converting {
    @Benchmark
    public String uiDataSetListConverting(Data data) throws JsonProcessingException {
        return data.mapper.writeValueAsString((Object)Utils.doUiDs((DataSetList)data.toConvert, (DsEvaluator)data.eval, (boolean)true));
    }

    @Benchmark
    public String flatDataConverting(Data data) throws JsonProcessingException {
        return data.mapper.writeValueAsString((Object)Utils.doFlatData((DataSetList)data.toConvert));
    }

    @State(value=Scope.Benchmark)
    public static class Data {
        private ObjectMapper mapper;
        private DataSetList toConvert;
        private DsEvaluator eval = EvaluatorMock.INSTANCE;

        @Setup
        public void setup() {
            this.mapper = new ObjectMapper();
            this.toConvert = TestData.createBensCases((CreationFacade)SimpleCreationFacade.INSTANCE, (String)"va");
        }
    }
}

