/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.qubership.atp.dataset.migration.DsRow;
import org.qubership.atp.dataset.migration.model.ExcelEvaluator;

public class SheetDataIterator
extends AbstractIterator<DsRow> {
    public final ExcelEvaluator excelEvaluator;
    private final Iterator<Row> sheetData;
    private final int valuesColumnIndex;
    private final State state = new State();

    public SheetDataIterator(Iterator<Row> sheetData, int valuesColumnIndex, ExcelEvaluator excelEvaluator) {
        this.sheetData = sheetData;
        this.valuesColumnIndex = valuesColumnIndex;
        this.excelEvaluator = excelEvaluator;
    }

    public static SheetDataIterator create(Sheet sheet, int valuesColumnIndex, ExcelEvaluator excelEvaluator) {
        Iterator rowIterator = sheet.rowIterator();
        rowIterator.next();
        return new SheetDataIterator(rowIterator, valuesColumnIndex, excelEvaluator);
    }

    private void setGroup(@Nonnull Cell newGroupCell) {
        String cellValue = this.getCellValue(newGroupCell);
        String group = cellValue.trim().isEmpty() ? null : cellValue;
        this.state.gotNewGroup = group != null && !group.equals(this.state.group);
        if (this.state.gotNewGroup) {
            this.state.group = group;
        }
        this.state.groupCell = newGroupCell;
    }

    private void setValue(@Nonnull Cell keyCell, @Nonnull Cell valueCell) {
        this.state.parameterKeyCell = keyCell;
        this.state.parameterValueCell = valueCell;
        String cellValue = this.getCellValue(this.state.parameterKeyCell);
        this.state.parameterKey = cellValue.trim().isEmpty() ? null : cellValue;
    }

    @Nonnull
    private String getCellValue(@Nullable Cell cell) {
        return this.excelEvaluator.getValue(cell);
    }

    protected DsRow computeNext() {
        while (this.sheetData.hasNext()) {
            Row row = this.sheetData.next();
            this.setGroup(row.getCell(0, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
            this.setValue(row.getCell(1, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK), row.getCell(this.valuesColumnIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
            if (!this.state.gotNewGroup && this.state.parameterKey == null) continue;
            return this.state;
        }
        return (DsRow)this.endOfData();
    }

    private static class State
    implements DsRow {
        private String group = null;
        private Cell groupCell;
        private boolean gotNewGroup;
        private String parameterKey;
        private Cell parameterKeyCell;
        private Cell parameterValueCell;

        private State() {
        }

        @Override
        public boolean gotNewGroup() {
            return this.gotNewGroup;
        }

        @Override
        @Nonnull
        public Cell getGroupCell() {
            return this.groupCell;
        }

        @Override
        @Nullable
        public String getGroup() {
            return this.group;
        }

        @Override
        @Nonnull
        public Cell getParameterKeyCell() {
            return this.parameterKeyCell;
        }

        @Override
        @Nullable
        public String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        @Nonnull
        public Cell getParameterValueCell() {
            return this.parameterValueCell;
        }

        @Override
        @Nonnull
        public String getCurrentLocationInfo() {
            if (this.groupCell == null) {
                return "UNKNOWN";
            }
            return this.groupCell.getSheet().getSheetName() + "|" + this.groupCell.getAddress().formatAsString();
        }
    }
}

