/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.model;

import com.google.common.base.MoreObjects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.qubership.atp.dataset.migration.model.ExcelEvaluator;

public class CellData {
    private CellType cellType = CellType._NONE;
    private String formula = "";
    private String value = "";
    private String location = "";

    public CellData(String formula, String location) {
        this(formula, "", location, CellType._NONE);
    }

    public CellData(String formula, String value, String location, CellType cellType) {
        this.formula = formula;
        this.value = value;
        this.location = location;
        this.cellType = cellType;
    }

    public CellData(ExcelEvaluator excelEvaluator, Cell cell) {
        this.location = cell.getSheet().getSheetName() + "!" + cell.getAddress().formatAsString();
        this.cellType = cell.getCellTypeEnum();
        this.value = excelEvaluator.getValue(cell);
        if (cell.getCellTypeEnum() == CellType.FORMULA) {
            this.formula = cell.getCellFormula();
        }
    }

    public String getFormula() {
        return this.formula;
    }

    public String getValue() {
        return this.value;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cellType", (Object)this.cellType).add("formula", (Object)this.formula).add("value", (Object)this.value).toString();
    }

    public CellType getCellType() {
        return this.cellType;
    }
}

