/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.ExcelFormulaAdapter;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;

public class UuidParser
implements ExcelFormulaAdapter {
    private static final String EXCEL_FORMULA_UUID = "CONCATENATE(DEC2HEX(RANDBETWEEN(0,4294967295),8),\"-\",DEC2HEX(RANDBETWEEN(0,65535),4),\"-\",DEC2HEX(RANDBETWEEN(16384,20479),4),\"-\",DEC2HEX(RANDBETWEEN(32768,49151),4),\"-\",DEC2HEX(RANDBETWEEN(0,65535),4),DEC2HEX(RANDBETWEEN(0,4294967295),8))";

    private static boolean isFormulaUpCase_Uuid(String formula) {
        return EXCEL_FORMULA_UUID.equals(formula);
    }

    @Override
    public FormulaType getType() {
        return FormulaType.UPCASE_UUID;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        String text = cellData.getFormula();
        if (!UuidParser.isFormulaUpCase_Uuid(text)) {
            throw new TransformationException("Text '" + text + "' is not UUID");
        }
        return "#UUID_UPPERCASE()";
    }

    @Override
    public boolean matches(CellData text) {
        return UuidParser.isFormulaUpCase_Uuid(text.getFormula());
    }
}

