/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Progress {
    private final Consumer<Integer> progressConsumer;
    private final long totalItems;
    private double rawProgress = 0.0;
    private int progress = 0;

    public Progress(Consumer<Integer> progressConsumer, long totalItems) {
        this.progressConsumer = progressConsumer;
        this.totalItems = totalItems;
    }

    public static Progress withTimeThreshold(Consumer<Integer> progressConsumer, long totalItems) {
        long[] lastNotifyTime = new long[]{-1L};
        return new Progress(percent -> {
            long curNotifyTime = System.currentTimeMillis();
            if (curNotifyTime - lastNotifyTime[0] > TimeUnit.SECONDS.toMillis(2L)) {
                progressConsumer.accept((Integer)percent);
                lastNotifyTime[0] = curNotifyTime;
            }
        }, totalItems);
    }

    public void increment(double by) {
        this.rawProgress += by;
        int newProgress = (int)(this.rawProgress * 100.0 / (double)this.totalItems);
        if (this.progress != newProgress) {
            this.progressConsumer.accept(newProgress);
            this.progress = newProgress;
        }
    }
}

