/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.apply;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;
import org.qubership.atp.dataset.migration.model.ToCreate;
import org.qubership.atp.dataset.migration.repo.DsServicesFacade;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.file.FileData;

public interface SetParam {
    public static final SetParam TEXT = (using, source, target, value) -> using.param.update(target.getId(), value.getDatasetValue());
    public static final SetParam LIST_VALUE = (using, source, target, value) -> {
        Attribute attr = target.getAttribute();
        String lvName = value.getDatasetValue();
        Preconditions.checkArgument((AttributeType.LIST == attr.getType() ? 1 : 0) != 0, (String)"Existing attribute has type '%s', but type '%s' expected.", (Object)attr.getType(), (Object)AttributeType.LIST);
        ListValue listValue = using.get_ListValue_ByNameOrCreate(attr, lvName);
        using.param.set(target.getDataSet().getId(), attr.getId(), null, null, null, listValue.getId());
    };
    public static final SetParam FILE = (using, source, target, value) -> {
        FileData fileData = target.getFileData();
        using.fs.save(fileData, (InputStream)new ByteArrayInputStream(value.getFile().getDataBuffer()), false);
        using.param.update(fileData.getParameterUuid(), value.getDatasetValue());
    };

    public void setParameterValue(DsServicesFacade var1, ToCreate var2, @Nonnull Parameter var3, Formula var4) throws TransformationException;
}

