/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.model;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.ContentTypes;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.qubership.atp.dataset.migration.model.FalloutReport;
import org.qubership.atp.dataset.model.impl.file.FileData;

public class AttachedFiles {
    public static List<Ole10Native> createAttachedFiles(XSSFWorkbook book, FalloutReport report) {
        try {
            List parts = book.getAllEmbedds();
            ArrayList<Ole10Native> files = new ArrayList<Ole10Native>(parts.size());
            parts.forEach(part -> {
                try {
                    files.add(Ole10Native.createFromEmbeddedOleObject((POIFSFileSystem)new POIFSFileSystem(part.getInputStream())));
                }
                catch (Ole10NativeException e) {
                    report.report("XSSFWorkbook", " ", "Invalid or unexcepted data format", e.getMessage());
                }
                catch (IOException e) {
                    report.report("XSSFWorkbook", " ", "", e.getMessage());
                }
            });
            return files;
        }
        catch (OpenXML4JException e) {
            report.report("XSSFWorkbook", " ", "Error when searching for attached files", e.getMessage());
            return Collections.emptyList();
        }
    }

    public static Optional<Ole10Native> findFileFromList(List<Ole10Native> attachedFiles, String name, String dsName) {
        Optional<Ole10Native> fileAttach = attachedFiles.stream().filter(file -> {
            String filePath = file.getFileName();
            String type = file.getLabel().replaceAll(".*\\.", "");
            return filePath.startsWith(dsName) && filePath.endsWith(name + '.' + type);
        }).findFirst();
        if (fileAttach.isPresent()) {
            return fileAttach;
        }
        return attachedFiles.stream().filter(file -> {
            String fileName = file.getLabel().replaceAll("\\..*", "");
            return fileName.equals(name);
        }).findFirst();
    }

    public static FileData createFileParameterFromAttachedFile(Ole10Native file, UUID uuid) {
        String fileName;
        String contentType = ContentTypes.getContentTypeFromFileExtension((String)(fileName = file.getLabel()));
        return new FileData(fileName, uuid, Strings.isNullOrEmpty((String)contentType) ? "plain/text" : contentType);
    }
}

