/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.model;

import com.google.common.base.MoreObjects;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;

public class Formula {
    private final CellData data;
    private final FormulaType formulaType;
    private final String datasetValue;
    private final Ole10Native file;

    public Formula(CellData data, FormulaType formulaType, String datasetValue, Ole10Native file) {
        this.data = data;
        this.formulaType = formulaType;
        this.datasetValue = datasetValue;
        this.file = file;
    }

    public String getLocation() {
        return this.data.getLocation();
    }

    public String getExcelFormulaValue() {
        return this.data.getValue();
    }

    public FormulaType getFormulaType() {
        return this.formulaType;
    }

    public String getExcelFormulaText() {
        return this.data.getFormula();
    }

    public String getDatasetValue() {
        return this.datasetValue;
    }

    public Ole10Native getFile() {
        return this.file;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("data", (Object)this.data).add("formulaType", (Object)this.formulaType).add("datasetValue", (Object)this.datasetValue).add("file", (Object)this.getFileName()).toString();
    }

    private String getFileName() {
        return this.file == null ? "" : this.file.getFileName();
    }
}

