/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.migration.formula.parsers;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellType;
import org.qubership.atp.dataset.migration.formula.ExcelFormulasEvaluator;
import org.qubership.atp.dataset.migration.formula.model.CellData;
import org.qubership.atp.dataset.migration.formula.model.ExcelFormulaAdapter;
import org.qubership.atp.dataset.migration.formula.model.Formula;
import org.qubership.atp.dataset.migration.formula.model.FormulaType;
import org.qubership.atp.dataset.migration.formula.model.TransformationException;

public class ConcatenateIntReferenceParser
implements ExcelFormulaAdapter {
    private final ExcelFormulasEvaluator evaluator;

    public ConcatenateIntReferenceParser(ExcelFormulasEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public FormulaType getType() {
        return FormulaType.CONCATANATION_INTERNAL_REFERENCES;
    }

    @Override
    public String transform(CellData cellData) throws TransformationException {
        String text = cellData.getFormula();
        String[] formulaParts = text.split("&");
        return Arrays.stream(formulaParts).map(String::trim).map(formulaPart -> new CellData((String)formulaPart, cellData.getValue(), cellData.getLocation(), CellType.FORMULA)).map(this.evaluator::getFormula).map(Formula::getDatasetValue).collect(Collectors.joining(""));
    }

    @Override
    public boolean matches(CellData cellData) {
        return cellData.getFormula().contains("&");
    }
}

